package algorithms;

import MainView;
import SortAlgorithm;

/**
//dichotomic insertion is a simple optimsation of insertion sort
//it is optimal in terms of comparisons, and does not require
//an additional stack. It does at most sum(i=1 to n)(log2 i) comparisons.
//however, because of its high moves complexity (n*n), it is still
//less efficient than 'smart' sorts.
//However, it makes an excellent intrdocutino to the notion of optimizing
//algorithms, and a good intermediate step before introducing
//shell sort
*/
public class InsertDichoSort2 extends SortAlgorithm {
	public InsertDichoSort2 (int t, MainView v) { super("Insert-Dicho2", t, v); }
	public void sort () {
		for (int i = 1; i < size; i++) {
// find by dichotomy before which item to insert the current
			int binf=0, bsup=i-1;
			int mid=(bsup+binf)/2;
			do {
				int res=compare(mid,i);
				if (res < 0) binf=mid+1;
				else if (res > 0) bsup=mid;
				else binf=bsup=mid+1;
				mid=(bsup+binf)/2;
			} while (bsup > binf);
// now insert it before binf
			if (mid < i-1) {
				int val=item(i);
				for (int k = i; k > mid; k--)
					exchange(k, k-1);
				assign(mid,val);
			} else if (compare(i-1,i) > 0)
					exchange(i,i-1);
		}
	}
}
