package algorithms;

import MainView;
import SortAlgorithm;

public class InsertDichoSort extends SortAlgorithm {
	public InsertDichoSort (int t, MainView v) { super("Insert-Dicho", t, v); }

	public void sort () {
		for (int i = 1; i < size; i++) {
// find by dichotomy before which item to insert the current
			if (compare(i-1,i) <= 0) continue;
			int binf=0, bsup=i-1;
			do {
				int mid=(bsup+binf)/2;
				int res=compare(mid,i);
				if (res < 0) binf=mid+1;
				else if (res > 0) bsup=mid;
				else binf=bsup=mid+1;
			} while (bsup > binf);
			
// now insert it before binf
			int val=item(i);
			for (int k = i; k > binf; k--)
				exchange(k, k-1);
			assign(binf,val);
		}
	}
};
