package algorithms;

import MainView;
import SortAlgorithm;

/**
 * this naive approach is unfortunately frequently used, because
 * it works well in some frequently occuring cases: the list
 * is almost sorted, and unsorted items are 'below' their final position.
 * (this happens for instance when sorting an array of invoices
 * by invoice number, when some invoices have been inserted in 'holes'
 * in the initial array.
 * use insertion sort instead if you want to be naive, or at least shaker sort.
*/
public class BubbleSort extends SortAlgorithm {
	public BubbleSort (int t, MainView v) { 
		super("Bubble Sort", t, v); 
	}
	
	public void sort () {
		boolean dep=false;
		int curndx=size;
		do {
			dep=false;
			for (int i=1; i < curndx; i++) {
				if (compare(i, i-1)<0) {
					exchange(i, i-1);
					dep=true;
				}
			}
			curndx--;
		} while (dep);
	}
}
