
import java.applet.*;
import java.awt.*;
import java.util.*;

import algorithms.*;

/**
* Put the class description here.
* @author Thomas Baudel
* @version VERSION 1 extended
**/
public class VisuTri extends Applet {
	
	static Color bgcolor=Color.white;
	static Color fg=Color.black;
	static Color bg=Color.lightGray;

	void initAlgos() {
		new BubbleSort(100, canvas);
		new BrickSort(100,canvas);
		new SelectionSort(100, canvas);	
		new InsertionSort(100, canvas);	
		new QuickSort(100, canvas);	
		new InsertDichoSort(100, canvas);	
		new InsertDichoSort2(100, canvas);	
		new ShakerSort(100, canvas);	
		new QuickerSort(100, canvas);	
		new HeapSort(100, canvas);
		new ShellSort(100, canvas);	
		new ShellSort2(100, canvas);	
		new InPlaceStableSort(100, canvas);
	}

    public void init() {
        super.init();
		algos=new Vector(0);
        setLayout(null);
		Font font=new Font("Helvetica", 0, 12);
        setBackground(bg);
        resize(640, 512);

        add(canvas = new MainView(this));
        canvas.setBackground(bgcolor);
        canvas.move(0, 32);
        canvas.resize(640, 480);
        canvas.show();
	
        add(sortChoice = new Choice());
        sortChoice.addItem("Selection");		
        sortChoice.addItem("BubbleSort");
        sortChoice.addItem("ShakerSort");
        sortChoice.addItem("Insertion");
        sortChoice.addItem("Insert/Dicho");
        sortChoice.addItem("Insert/Dicho2");
        sortChoice.addItem("HeapSort");
        sortChoice.addItem("BrickSort");
        sortChoice.addItem("QuickSort");
        sortChoice.addItem("QuickerSort");
        sortChoice.addItem("ShellSort");
        sortChoice.addItem("ShellSort2");
        sortChoice.addItem("In Place Stable");
        sortChoice.addItem("________________");
        sortChoice.addItem("Clear All");
        sortChoice.setFont(font);
        sortChoice.move(5, 2);
        sortChoice.resize(120, 26);
        sortChoice.setBackground(bg);
        sortChoice.setForeground(fg);
        sortChoice.show();

        add(action = new Choice());
        action.addItem("Random");
        action.addItem("Sorted");
        action.addItem("Inverted");
        action.addItem("Almost Sorted");
        action.addItem("Almost Inverted");
        action.addItem("Triangle");
        action.addItem("Inverted Triangle");
        action.addItem("Bell Shaped");
        action.addItem("Custom");
        action.addItem("_______________");
        action.addItem("Suspend");
        action.addItem("Resume");
        action.setFont(font);
        action.move(127, 2);
        action.resize(130, 26);
        action.setBackground(bg);
        action.setForeground(fg);
        action.show();

        add(label = new java.awt.Label());
        label.setText("Compare");
        label.setBackground(bg);
        label.setForeground(fg);
        label.setFont(font);
		label.setAlignment(2);
        label.move(259, 2);
        label.resize(80, 26);
        label.show();

        add(textfield = new java.awt.TextField());
        textfield.setText(".5");
        textfield.setBackground(bgcolor);
        textfield.setForeground(fg);
        textfield.move(341, 1);
        textfield.resize(40, 28);
        textfield.show();

        add(label1 = new java.awt.Label());
        label1.setText("Exchange");
        label1.setBackground(bg);
        label1.setForeground(fg);
        label1.setFont(font);
		label1.setAlignment(2);
        label1.move(383, 2);
        label1.resize(80, 26);
        label1.show();

        add(textfield1 = new java.awt.TextField());
        textfield1.setText(".1");
        textfield1.setBackground(bgcolor);
        textfield1.setForeground(fg);
        textfield1.move(465, 1);
        textfield1.resize(40, 28);
        textfield1.show();

		initAlgos();
    }
	public boolean action (Event evt, Object arg) {
		if (AjouteTri(new String(arg.toString()))) return true;
		else Simule(arg.toString());
		return false;
	}

    public boolean AjouteTri (String arg) {
		boolean res=false;
		if (arg.equals("Clear All")) {
			for (int i =0; i < algos.size(); i++) {
				SortAlgorithm t = (SortAlgorithm) algos.elementAt(i);
				t.stop();
			}
			algos.removeAllElements();
			algos.setSize(0);
			Graphics g = canvas.getGraphics();
			Rectangle bounds = canvas.bounds();
			if (g!=null) g.clearRect(0, 0, bounds.width, bounds.height);
			res=true;
		} else if (arg.equals("BubbleSort")) {
			algos.addElement(new BubbleSort(100, canvas));
			res=true;			
		} else if (arg.equals("BrickSort")) {
			algos.addElement(new BrickSort(100, canvas));
			res=true;			
		} else if (arg.equals("Selection")) {
			algos.addElement(new SelectionSort(100, canvas));	
			res=true;
		} else if (arg.equals("Insertion")) {
			algos.addElement(new InsertionSort(100, canvas));	
			res=true;
		} else if (arg.equals("QuickSort")) {
			algos.addElement(new QuickSort(100, canvas));	
			res=true;
		}else if (arg.equals("Insert/Dicho" )) {
			algos.addElement(new InsertDichoSort(100, canvas));	
			res=true;
		}else if (arg.equals("Insert/Dicho2" )) {
			algos.addElement(new InsertDichoSort2(100, canvas));	
			res=true;
		}else if (arg.equals("ShakerSort" )) {
			algos.addElement(new ShakerSort(100, canvas));	
			res=true;
		}else if (arg.equals("QuickerSort" )) {
			algos.addElement(new QuickerSort(100, canvas));	
			res=true;
		}else if (arg.equals("HeapSort" )) {
			algos.addElement(new HeapSort(100, canvas));
			res=true;	
		}else if (arg.equals("ShellSort")) {
			algos.addElement(new ShellSort(100, canvas));	
			res=true;
		}else if (arg.equals("ShellSort2")) {
			algos.addElement(new ShellSort2(100, canvas));	
			res=true;
		}else if (arg.equals("In Place Stable")) {
			algos.addElement(new InPlaceStableSort(100, canvas));
			res=true;	
		}
		if (res) canvas.repaint();
		return res;
    }

synchronized public void Simule (String arg) {
		if (arg.equals("Suspend")) {
			for (int i =0; i < algos.size(); i++) {
				SortAlgorithm t = (SortAlgorithm) algos.elementAt(i);
				if (t.isAlive()) t.suspend();
			}
		} if (arg.equals("Resume")) {
			for (int i =0; i < algos.size(); i++) {
				SortAlgorithm t = (SortAlgorithm) algos.elementAt(i);
				if (t.isAlive()) t.resume();
			}
		} else {
			boolean reinitialized=true;
			for (int i =0; i < algos.size(); i++) {
				SortAlgorithm t = (SortAlgorithm) algos.elementAt(i);
				reinitialized &= t.reinit((String) arg, 
								new Float(textfield.getText()).floatValue(), 
								new Float(textfield1.getText()).floatValue());
			}
			if (reinitialized) {
				for (int i =0; i < algos.size(); i++) {
					SortAlgorithm t = (SortAlgorithm) algos.elementAt(i);
					t.go();
				}	
				Graphics g = canvas.getGraphics();
				Rectangle bounds = canvas.bounds();
				if (g!=null) g.clearRect(0, 0, bounds.width, bounds.height);
				canvas.repaint();
			}
		}
    }

    MainView canvas;
    Choice sortChoice;
    TextField textfield;
    Label label;
    Label label1;
    TextField textfield1;
    Choice action;
	Vector algos;
}
