import java.awt.Graphics;
import java.awt.Point;

public abstract class SortAlgorithm extends Thread {
	
// the important members
	protected int size;
	int tableau[];
	String nom;
	protected float cmpt, ext;
// to make statistics	
	int nEchanges;
	int nCompare;
	int lastcomp1, lastcomp2;
	int lastchange1, lastchange2;
	MainView visu;

// to optimize repaint:
	boolean damaged=false;
	Point damages[];
	int damage_cnt=0;	
// to allow restarting a sort
	boolean started=false;

	public SortAlgorithm(String n, int t, MainView v) {
		super(n);
		nom=n;
		cmpt=50; ext=10;
		visu=v;
		size=t;
		tableau=new int [t];
		damages=new Point [200];
		for (int i=0;i<200;i++)
			damages[i]=new Point(0,0);

		reinit("Sorted", (float) .5, (float) .1);
	}

// members to be used exclusively in subclasses to handle the sort

	public abstract void sort();
	
	protected void exchange (int i, int j) {
		damage(i, tableau[i]); 
		damage(j, tableau[j]);
		int tmp=tableau[i];
		tableau[i]=tableau[j];
		tableau[j]=tmp;
		damage(lastchange1, tableau[lastchange1]);
		damage(lastchange2, tableau[lastchange2]);
		lastchange1=i;lastchange2=j;
		damage(i, tableau[i]); 
		damage(j, tableau[j]);
		nEchanges++;
		delay(ext);
	}
	
	protected int compare (int i, int j) {
		nCompare++;
		damage(lastcomp1, tableau[lastcomp1]);
		damage(lastcomp2, tableau[lastcomp2]);
		lastcomp1=i;lastcomp2=j;
		damage(i, tableau[i]);
		damage(j, tableau[j]);
		delay(cmpt);
		return tableau[i] - tableau[j];
	}
	
	protected int compare_val (int val, int i) {	
		nCompare++;
		damage(lastcomp1, tableau[lastcomp1]);
		lastcomp1=i;
		damage(i, tableau[i]);
		delay(cmpt);
		return val - tableau[i];
	}
	
	protected void assign (int ndx, int val) {
		damage(lastchange1, tableau[lastchange1]);
		damage(lastchange2, tableau[lastchange2]);
		lastchange1=lastchange2=ndx;
		damage(ndx, val);
		damage(ndx, tableau[ndx]);
		tableau[ndx]=val;
		nEchanges++;
		delay(ext);
	}
	
	protected int item (int i) {
		damage(lastcomp2, tableau[lastcomp2]);
		lastcomp2=i;
		return tableau[i];
	}
	
	protected void delay(float f) {
		if (f==0) return;
		try {
			sleep((long)f);
		} catch (Exception e) { if (e != null) e.printStackTrace();}
	}
	
// utilities used internally
	boolean dlocked=false;
	// making this synchronized really broke the scheduler
	synchronized void get_damage_lock() {
		while (dlocked) { try { wait(); } catch (Exception e) {}}
		dlocked = true;
	}
	synchronized void release_damage_lock() { dlocked=false; notifyAll(); }

	void damage (int i, int ndx) {
		get_damage_lock();
		damaged=true;
		damages[damage_cnt].x=i;
		damages[damage_cnt].y=ndx;
		if (damage_cnt < 199) damage_cnt++;
//		damages.addElement(p);
		release_damage_lock();
		visu.repairs.wakeup();
	}
	
	void common_paint(int x, int y, Graphics g) {
		g.setColor(visu.mvcolor);
		g.fillRect(x+1+lastchange1*2, y+1+(size-tableau[lastchange1])*2, 2, 2);
		g.fillRect(x+1+lastchange2*2, y+1+(size-tableau[lastchange2])*2, 2, 2);

		g.setColor(visu.cpcolor);
		g.fillRect(x+1+lastcomp1*2, y+1+(size-tableau[lastcomp1])*2, 2,2);
		g.fillRect(x+1+lastcomp2*2, y+1+(size-tableau[lastcomp2])*2, 2,2);

		g.setColor(visu.fgcolor);
		g.setFont(visu.font);
		float val=(float) ((((float)nEchanges)*ext)/100.0 + (((float)nCompare)*cmpt)/100.0);
		g.drawString(Integer.toString(nCompare), x+100, y+size*2 + 18);
		g.drawString(Integer.toString(nEchanges), x+135, y+size*2 + 18);
		g.drawString(Float.toString(val), x+170, y+size*2 + 18);
		damaged=false;
		damage_cnt=0;
	}
	
	void repair (int x, int y, Graphics g) {
		if (!damaged) return;
		get_damage_lock();
		//  for each item in damages: clear it even if it is useless
		// this should be optimized, because it makes some sorts look faster than others...
		g.setColor(visu.cellcolor);
		for (int i=0; i<damage_cnt; i++) {
			Point p = damages[i];
			g.clearRect(x+1+p.x*2, y+1+(size-p.y)*2, 2, 2);
		}
		// for each index in the damage array: paint the correct item
		for (int i=0; i<damage_cnt; i++) { 
			Point p = damages[i];
			if (p.x != lastchange1 && p.x!= lastchange2 && p.x!= lastcomp1 && p.x != lastcomp2)
				g.fillRect(x+1+p.x*2, y+1+(size-tableau[p.x])*2, 2, 2);
		}
		g.clearRect(x+100, y+size*2+6, 115, 20);
		common_paint(x, y, g);
		release_damage_lock();
	}
	
	void dessine (int x, int y, Graphics g) {
		get_damage_lock();
		g.clearRect(x-2, y-2, size*2+4, y+size*2+20);
		g.setColor(visu.cellcolor);
		for (int i=0; i < size; i++) {
			if (i != lastchange1 && i!= lastchange2 && i!= lastcomp1 && i != lastcomp2)
				g.fillRect(x+1+i*2, y+ 1+(size-tableau[i])*2, 2, 2);
		}
		g.setColor(visu.fgcolor);
		g.setFont(visu.font);
		g.drawString(nom, x+10, y+size*2 + 18);
		g.drawRect(x, y, size*2+2, size*2+4);
		common_paint(x, y, g);
		release_damage_lock();
	}
	
	
	public synchronized void go() {
		started=true;
		if (!isAlive()) start();
		else notifyAll();
	}
	
	public void run() {
		while (true) {
			if (started) {
				nEchanges=nCompare=0;
				delay(100);
				sort();
				started=false;
				delay(100);
			}
			idle();
		}
	}
	
	synchronized void idle() {
		try { wait(); } catch(Exception e) {}
	}
	
	boolean reinit(String s, float c, float e) {
		boolean res=false;
		cmpt=c*100; ext=e*100;
		if (started) return true;
		if (s.equals("Sorted")) {
			for (int i=0; i< size; i++)
				tableau[i]=i;
			res=true;
		} else if (s.equals("Inverted")) {
			for (int i=0; i< size; i++)
				tableau[i]=size - i - 1;
			res=true;	
		} else if (s.equals("Random")) {
			for (int i=0; i< size; i++)
				tableau[i] = (int) (Math.random()*(double)size);
			res=true;
		} else if (s.equals("Almost Sorted")) {
			for (int i=0; i< size; i++)
				tableau[i]= Math.abs(i + (int) (Math.random()*(double) 10) - 5) % size;
			res=true;
		} else if (s.equals("Almost Inverted")) {
			for (int i=0; i< size; i++)
				tableau[i]= Math.abs(size - i + (int) (Math.random()*(double) 10) - 5) % size;
			res=true;
		} else if (s.equals("Triangle")) {
			for (int i=0; i< size/2; i++)
				tableau[i]= i*2;
			for (int i=size/2; i< size; i++)
				tableau[i]= (size - i)*2;
			res=true;
		} else if (s.equals("Inverted Triangle")) {
			for (int i=0; i< size/2; i++)
				tableau[i]= (size - i*2);
			for (int i=size/2; i < size; i++)
				tableau[i]= (i*2-size);
			res=true;
		} else if (s.equals("Bell Shaped")) {
			for (int i=0; i< size; i++)
				tableau[i]= (int) (Math.sin(((double)i)/((double)size)*3.14)*(double)size);
			res=true;
		}
		if (res) visu.repaint();
		return res;
	}
};

