import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

class RepairThread extends Thread {
	RepairThread(MainView v) { super("RepairThread"); visu=v; waken=false; }
	
	public void run() { while(true) loop(); }
	synchronized void loop() {
			try { wait(100); } catch (Exception e) {}
			while (waken) {
				waken=false;
				visu.paint(null);
			}
	}
	public void wakeup() { waken=true; }
	boolean waken;
	MainView visu;
};

public class MainView extends Canvas {
	VisuTri visu;
	RepairThread repairs;
	Thread drawthread;
	Font font;
	Color fgcolor=Color.darkGray;
	Color cellcolor=Color.green.darker();
	Color mvcolor = Color.magenta.darker();
	Color cpcolor= Color.red.darker();
	boolean drawing=false;

	MainView (VisuTri v) {
		super();
		visu=v;
		font=new Font("Helvetica", 0, 10);
		repairs=new RepairThread(this);
		repairs.start();
	}
	
	synchronized void drawing_lock() {
		while(drawing) { try { wait(); } catch(Exception e) {}}
		drawing=true;
	}
	
	synchronized void release_lock() { drawing=false; notifyAll(); }

	public void paint (Graphics g) {
		drawing_lock();
		int k=0;
		boolean simple_repair=false;
		if (g == null) { 
			g=getGraphics(); simple_repair=true; 
		} 
		if (g==null) return;
		for (int j=0; k<visu.algos.size() && j < 400; j+=230)
			for (int i = 0; k < visu.algos.size() && i < 600; i+= 210) {
				if (simple_repair)
					((SortAlgorithm) visu.algos.elementAt(k++)).repair(i+5, j+10, g);
				else 
					((SortAlgorithm) visu.algos.elementAt(k++)).dessine (i+5, j+10, g);
			}
		release_lock();
	}
}
