/*    
	Thomas Baudel                     thomas@dgp.toronto.edu
									  thomas@lri.fr
	Thursday, July 18, 1991 3:47:10 PM
*/

#include <Values.h>
#include <Types.h>
#include <Resources.h>
#include <QuickDraw.h>
#include <Fonts.h>
#include <Events.h>
#include <Windows.h>
#include <Menus.h>
#include <stdio.h>
#include <TextEdit.h>
#include <Dialogs.h>
#include <Desk.h>
#include <OSEvents.h>
#include <Memory.h>
#include <Packages.h>
#include <HyperXcmd.h>
#include "DtgAnalyse.h"

#pragma segment DtgTrack

void BuildCommand (char*, StringPtr, short , short, short , short);
void ErrAbort(XCmdPtr, char*);

pascal void ENTRYPOINT (XCmdPtr param)
{
	DtgResult *r;
	EventRecord evt;
	char ch[256];
	if (GetOSEvent (app2Mask, &evt)) {
		r = (DtgResult*) evt.message;
		if (r) {
			BuildCommand (ch, r->name, r->start.h, r->start.v, r->end.h, r->end.v);
// DebugStr ((Str255) ch);
			SendHCMessage(param, (StringPtr) ch);
		}
	}
	param->returnValue = NULL;
}

void BuildCommand (char* res, StringPtr name, short x, short y, short ex, short ey)
{
	char r[256], buf [256]; 
	int i=1;
	buf[0]= 0x22;
	while (i <= name[0]) {
		buf[i]= name [i];
		i++;
	}
	buf[i++]=' ';
	buf[i]=0;
	r[0] = 0;
	
	strcat (r, "send ");
	strcat (r, buf);
	numtostring (x, buf);
	strcat (r, buf);
	strcat (r, ", ");
	numtostring (y, buf);
	strcat (r, buf);
	strcat (r, ", ");
	numtostring (ex, buf);
	strcat (r, buf);
	strcat (r, ", ");
	numtostring (ey, buf);
	strcat (r, buf);
	buf[0]=0x22; buf[1]=0;
	strcat (r, buf);
	strcat (r, " to this stack");

	for (i=0; r[i]; i++)
		res [i+1] = r[i];
	res[0] = i;
}

/*
char *c, b[256]; int i=0;
	c = r+1;
	strcpy (c, "send "); c += 5; 
	*c = 0x22; c++;
	strcpy (c, &(n[1])); c += n[0]; i += n[0] + 7;
	strcpy (c, " "); c++;
	numtostring (x, b);
	strcpy (c, b); c += strlen(b); i += strlen(b) + 2;
	strcpy (c, ", "); c += 2;
	numtostring (y, b);
	strcpy (c, b); c += strlen(b); i += strlen(b) + 14;
	*c = 0x22; c++;
	strcpy (c, " to this card");
	r[0]=(char) i;
*/



void 
ErrAbort(XCmdPtr paramPtr, char *str)
{
	Handle  nuHndl;
/* Debugger(); */
	nuHndl = NewHandle((long)(strlen(str)+1));
	if (nuHndl == nil) return;
	strcpy((char *)*nuHndl,str);
	paramPtr->returnValue = nuHndl;
}
