extern "C" {
#include "DtgAnalyse.h"
#include <Lists.h>
}

#define FILE_TYPE 'Gest'
#define CREATOR_TYPE 'GesT'
#define RES1_TYPE 'GEST'
#define RES2_TYPE 'GESE'
#define RES3_TYPE 'DTGG'

extern DtgLink dtglink;

class FENETRE_SET ;
class GEST_CLASS;
class GEST_EXAMPLE;

class DTG_POINT {
public:
	short x, y, z;
	FingerBend fingers[5];
	long tc;
	DTG_POINT (short, short, short, FingerBend*, long);
};

class GEST_EXAMPLE {
public:
	Handle Res;
	FVList vectors;
	GEST_CLASS* Parent;
	GEST_EXAMPLE* Suivant;
	int Length;
	
	short Enregistre ();
	void Supprime ();
	GEST_EXAMPLE (DtgGrammar*, GEST_CLASS*, short);
	~GEST_EXAMPLE ();
};


class GEST_CLASS {
friend class FENETRE_SET;
friend class GEST_EXAMPLE;
protected :
		GEST_EXAMPLE *Examples, *Current;
		int	nExamples;
		ListHandle ExamplesList;
		DtgConfig	Params;
		Handle 	Res;
public:		
		GEST_CLASS (FENETRE_SET*, Handle, Str255);
		 ~GEST_CLASS ();
		 
		void Name (Str255);
		int Dessine (FENETRE_SET*);
		void Touche (FENETRE_SET*, EventRecord*);
 		void Clique (FENETRE_SET*, EventRecord*);
		void MenuEdition (FENETRE_SET*, short);
 		void Enregistre ();
		
		void SaisieParams (Str255, DtgConfig&, Boolean);
} ;

class FENETRE_SET : public FENETRE {
friend class GEST_CLASS;
protected :
			GEST_CLASS *CurClass;
		  	int NbChamps, CurItem;
			DtgGrammar gram;
			void ChangeChamp (Str255, short);
			void Analyse (short);
			void Resolution ();
			void RemoveCurrent ();
public:			
			FENETRE_SET (Str255, int);
			~FENETRE_SET ();
			
		int Enregistre (int);
  		void Oisif (Boolean);
		int Dessine (RgnHandle); 
		void Active (int); 
		void Touche (EventRecord*); 
		void Clique (EventRecord*); 
		void Menu (int); 
		void MenuEdition(short);
		void Teste ();
		void ShowValues ();
};


