/* INCLUDE  */

# include <Types.h> 				/* Nearly always required */
# include <QuickDraw.h> 			/* To access the qd globals */
# include <ToolUtils.h> 			/* CursHandle and iBeamCursor */
# include <Fonts.h> 
# include <Events.h>
# include <OSEvents.h>
#include <CursorCtl.h>
# include <OSEvents.h>
# include <Errors.h>
# include <Files.h>
# include <String.h>
# include <Printing.h>
# include <memory.h>	
#include <Desk.h>
# include <Packages.h>
# include <Resources.h>	
# include <windows.h>
# include <dialogs.h>				/* InitDialogs() and GetNewDialog() */
# include <menus.h>
# include <SegLoad.h>	
# include <OSUtils.h>	
# include <Values.h>


#include "main.h"
#include "Gesture.h"

#define	AjoutChampId 	1
#define		EnleveChampId	2
#define ResolutionId	4
#define DebutId		5
#define FinId				6
#define ChampsId	8

#define LargeurFen	700
#define ParamsDialogue	134
#define ResDialogue	129

#pragma segment Gesture

inline int abs(int i) { return i>0 ? i : (-i) ; }

FENETRE_SET :: FENETRE_SET (Str255 Titre, int ref)
: FENETRE (Titre, BaseId, false, false), NbChamps(0), CurClass  ((GEST_CLASS*) 0), CurItem (0)
{ 	
		short Test; Handle h;
		LeFichier = ref; Test = GetVol(NULL, &LeVolume);
		if (! LeFichier) {
				FInfo finfo;
				finfo.fdType=FILE_TYPE; finfo.fdCreator = CREATOR_TYPE; finfo.fdFlags =0;
				CreateResFile (Titre); 
				Test=SetFInfo (Titre, LeVolume, &finfo);
				LeFichier = OpenResFile (Titre);
if (ResError()) Debugger();
				DtgInitGrammar (&gram);
				h = NewHandle(sizeof(FLOAT)*4);
				AddResource (h, RES3_TYPE, 0, Titre);
		} else {
			UseResFile (LeFichier); 	
			NbChamps = Count1Resources (RES1_TYPE);
			DtgInitGrammar (&gram);
			h = GetResource(RES3_TYPE, 0);
			if (!h)  { 	
				h = NewHandle(sizeof(FLOAT)*4);
				AddResource (h, RES3_TYPE, 0, Titre);
			} else {
				HLock(h);
				gram.x_size=(*(FLOAT**) h)[0];
				gram.y_size=(*(FLOAT**) h)[1];
				gram.x_resolution=(*(FLOAT**) h)[2];
				gram.y_resolution=(*(FLOAT**) h)[3];
				HUnlock(h); 
				ChangedResource(h); 
			}
			HPurge(h);
		}
		ShowWindow((WindowPtr) &Fen);
}

FENETRE_SET :: ~FENETRE_SET ()
{
	if (CurItem) CheckItem (LeMenu, CurItem, false);
	for (short i  = 0; i < NbChamps; i++ ) DelMenuItem (LeMenu, ChampsId);
	DtgFreeGrammar (&gram);
	if (CurClass) delete CurClass; 
	CloseResFile (LeFichier);
	LeFichier = 0;
	if (ResError()) Debugger();
}

int 
FENETRE_SET :: Enregistre (int what) 
{
	short f, id, test, i, j, nr, nt; 
	Handle h;
	ResType tp;
	Str255 ch; 
	SFTypeList tl; 
	SFReply rep;
	Point p;  
	FInfo finfo; 
	
	if (CurClass) CurClass->Enregistre ();
	if (Change) {
			UpdateResFile(LeFichier);
			Change = 0; 
	} 
	switch (what) {
	case 0:  break;
	case 1 : Name(ch);
			test= FSOpen (ch, LeVolume, &f);
			if (f) {
				UseResFile (LeFichier);
				// *** could clear the data fork
				Analyse (f);
				FSClose(f);
			}
			break;
	case 2 :  p.h = 60; p.v = 60;
			Name(ch);
			SFPutFile (p, "\pNew gesture file name", ch, NULL, &rep);
			if (rep.good) {
				if (CurClass) {
						delete CurClass;
						CurClass = 0;
						if (CurItem) CheckItem (LeMenu, CurItem, false);
						CurItem = 0;
						SetPort ((GrafPtr) &Fen);
						EraseRect (&Fen.port.portRect);
				}
				if (! IUCompString (ch, "\pUntitled")) {
						SetVol (NULL, LeVolume);
						CloseResFile (LeFichier);
						Rename (ch, LeVolume, rep.fName);
						LeFichier=OpenResFile(rep.fName);
						SetWTitle ((WindowPtr) &Fen, rep.fName);
				} else {
						SetVol (NULL, rep.vRefNum);
						LeVolume = rep.vRefNum;
						finfo.fdType= FILE_TYPE; 
						finfo.fdCreator = CREATOR_TYPE; 
						finfo.fdFlags =0;
						CreateResFile (rep.fName); 
						test=SetFInfo (rep.fName, LeVolume, &finfo);
						f = OpenResFile (rep.fName);
						UseResFile (LeFichier);
						nt = Count1Types();
						for (i = 1; i <= nt; i++) {
							UseResFile (LeFichier);
							Get1IndType (&tp, i);
							nr = Count1Resources (tp);
							for (j= 1 ; j<= nr; j++) {
								UseResFile (LeFichier);
								h = Get1IndResource (tp, j);
								GetResInfo (h, &id, &tp, ch);
								DetachResource (h);
								UseResFile (f);
								AddResource (h, tp, id, ch);
								UpdateResFile (f);
							}
						}
						SetWTitle ((WindowPtr) &Fen, rep.fName);
						CloseResFile (LeFichier);
						LeFichier = f;
					}
				}
			break;
		}
	return 1; 
}

int FENETRE_SET :: Dessine (RgnHandle r)
{ 
	PenNormal();
	if(! ImpressionCur) EraseRgn(r);
	if (CurClass) return CurClass->Dessine (this);
	else return MAXSHORT;
}

void FENETRE_SET :: ChangeChamp (Str255 Current, short  theItem)
{   
		if (CurClass) { 
				CheckItem (LeMenu, CurItem, false);
				SetPort ((GrafPtr) &Fen);
				EraseRect (&Fen.port.portRect);
				delete CurClass;
				UpdateResFile(LeFichier);
	if (ResError()) Debugger();
				CurClass = NULL;
		}
		if (Current) {
			CurClass = new GEST_CLASS (this, GetNamedResource ('GEST', Current), Current);
			CheckItem (LeMenu, theItem, true);
			CurClass->Dessine (this);
			CurItem = theItem;
		} else {
			Current[0] =0;
			if (Demande ("\pEnter new Gesture Class Name", Current)) {
				CurClass  = new GEST_CLASS (this, (Handle) 0, Current);
				NbChamps++;
				AppendMenu (LeMenu, Current);
				theItem = CountMItems (LeMenu);
				CheckItem (LeMenu, theItem, true);
				CurItem = theItem;
			}
		}
}

void FENETRE_SET :: Active (int Flag)
{
			Handle h; int j; ResType t; Str255 ch;
			if (Flag) {
						UseResFile(LeFichier);
						while (CountMItems (LeMenu) >= ChampsId) DelMenuItem (LeMenu, ChampsId);
						for (short i  = 1; i <= NbChamps; i++ ) {
								h = Get1IndResource (RES1_TYPE, i);
								GetResInfo (h, (short*) &j, &t, ch);
								AppendMenu (LeMenu, ch);
						} 
						if (CurItem) CheckItem (LeMenu, CurItem, true);
						InsertMenu (LeMenu, 0); DrawMenuBar();
				} else {
						if (CurItem) CheckItem (LeMenu, CurItem, false);
						DeleteMenu (TypeFenetre); 
						DrawMenuBar();
				} 
}

void FENETRE_SET :: Oisif (Boolean front) 
{ 
	DtgRecord dtgrec; 
	DtgHand hand;
	if (front)
		if (DtgContinuous (&dtglink, &dtgrec)) 
			if (DtgProject (&gram, &dtgrec, &hand)) {
				PutMouse (hand.x, hand.y); // set cursor (hand) ? ***
			}
}

void FENETRE_SET :: Touche (EventRecord* e) 
{ 
		if (CurClass) { CurClass->Touche (this, e); }
		Change = 1;
}

void FENETRE_SET :: Clique (EventRecord* e) 
{ 
		if (CurClass) { CurClass->Clique (this, e); }
		Change = 1;
}

void FENETRE_SET :: MenuEdition (short i) 
{ 
	if (i>3) Teste (); 
	else ShowValues();
	if (CurClass) { CurClass->MenuEdition (this, i); }
}

void FENETRE_SET :: Analyse (short f) 
{ 
		FV fv = FvAlloc();
		Handle  h;
		Str255 ch; 
		int i, j, k; 
		ResType t;
		
		UseResFile (LeFichier);
		InitCursorCtl (NULL); 
		for (i = 1; i <= NbChamps; i++) {
					h = Get1IndResource (RES1_TYPE,  i);
				if (! h) Debugger();
					GetResInfo (h, (short*) &j, &t, ch);
					ChangeChamp (ch, (short)( i + ChampsId - 1)); // *** i + ChampsId - 1 not clean 
					for (GEST_EXAMPLE* ge=CurClass->Examples; ge; ge=ge->Suivant) {
						SpinCursor (16);
						FvInit (fv);
						if (! ge->Res) Debugger();
						HLock(ge->Res);
						if (MemError()) Debugger();
						DTG_POINT* p= (DTG_POINT*) *(ge->Res);
						CurClass->Params.start.position.h = (short) (p[0].x / 100); 
						CurClass->Params.start.position.v = (short) (p[0].y / 100);
						// *** utiliser une fct de conversion de DtgAnalyse au lieu de faire les choses en dur ***
						for (k=0; k< ge->Length; k++) 
							FvAddPoint (fv, p[k].x, p[k].y, p[k].z , p[k].fingers, p[k].tc);
						HUnlock(ge->Res);
						if (ge->vectors.vector)
							FreeVector (ge->vectors.vector);

						FvCalc(fv);
						ge->vectors.vector=VectorCopy(fv->y); 
						if (ge->Suivant)
							ge->vectors.suivant=&(ge->Suivant->vectors);
						else ge->vectors.suivant=NULL;
					}
					CurClass->Params.id=i;
					if (CurClass->Examples) 
						CurClass->Params.vectors=&(CurClass->Examples->vectors);
					else CurClass->Params.vectors=NULL;
					SpinCursor (16);
					DtgAddConfig (&gram, &(CurClass->Params));
					SpinCursor (16);
		}
		DtgCompile (&gram);
		SpinCursor (16);
		if (f) {
			DtgSaveGrammar (&gram, f);
			SpinCursor (16);
		}
		Show_Cursor (ARROW_CURSOR); CurCursor=ARROW_CURSOR;
		FvFree(fv);
}

void 
FENETRE_SET :: Resolution ()
{
	GrafPtr 	savePort; 
	DialogPtr	theDialog; 
	short itemHit, i, vp, main_faite=0;
	int hand[20];
	DtgRecord m;
	Handle h;
	Rect r;
	decform f;
	decimal d;
	char chaine[255];  
	extended tamp;
	GetPort(&savePort);
	theDialog = GetNewDialog(ResDialogue, nil, (WindowPtr) -1); 
	
	f.style = FIXEDDECIMAL;
	f.digits = 3; // *** pour l'instant ca bugue quand on compile avec la lib 68881
	
	tamp=gram.x_size;
	num2dec(&f, tamp , &d); 
	dec2str(&f, &d, chaine); 
	GetDItem(theDialog, 4, &i, &h,&r);
	setitext (h, chaine);
	tamp=gram.y_size;
	num2dec(&f, tamp , &d); 
	dec2str(&f, &d, chaine); 
	GetDItem(theDialog, 5, &i, &h,&r);
	setitext (h, chaine);
	tamp=gram.x_size*gram.x_resolution;
	num2dec(&f, tamp, &d); 
	dec2str(&f, &d, chaine); 
	GetDItem(theDialog, 6, &i, &h,&r);
	setitext (h, chaine);
	tamp=gram.y_size*gram.y_resolution;
	num2dec(&f, tamp, &d); 
	dec2str(&f, &d, chaine); 
	GetDItem(theDialog, 7, &i, &h,&r);
	setitext (h, chaine);	
	// *** ajouter l'offset ***
	
	ShowWindow(theDialog); SetPort(theDialog);
	
	do { 
		ModalDialog(nil, &itemHit);
		if (itemHit>=12) {
			 long t = TickCount() + 60*10;
			while (! DtgContinuous (&dtglink, &m) && (TickCount() < t)); 
			if (TickCount() >= t) DtgError ("\pno response", 0);
			else {
				if (itemHit==12) { // main fermee
					for (i=0; i<10; i++)
						hand[i]=m.flex[i];
				} else { // main ouverte
					for (i=0; i<10; i++)
						hand[i+10]=m.flex[i];
				}
				
	SetPort(savePort);			
	Point p;
	TextMode (srcCopy);
	PenMode (srcCopy);
	for (i =0; i < 10; i++) {
			p.h= (i/2)*50 + 250;
			p.v= 175 + (i%2)*20;
			SetRect (&r,  p.h , p.v - 15, p.h + 45, p.v + 5 );
			EraseRect (&r);
			MoveTo (p.h , p.v);
			NumToString (hand[i], (Str255) chaine);
			DrawString ((Str255) chaine);
	}
	for (i =0; i < 10; i++) {
			p.h= (i/2)*50 + 250;
			p.v= 220 + (i%2)*20;
			SetRect (&r,  p.h , p.v - 15, p.h + 45, p.v + 5 );
			EraseRect (&r);
			MoveTo (p.h , p.v);
			NumToString (hand[i+10], (Str255) chaine);
			DrawString ((Str255) chaine);
	}
	SetPort(theDialog);
	
				main_faite++;
			}
		}
	} while (itemHit > 2);
// ecriture des parametres	
	if (itemHit == 1) { 
		GetDItem(theDialog, 4, &i, &h,&r);
		getitext(h, chaine); i=0; vp=0;
		str2dec(chaine, &i, &d, &vp); 
		if (vp)
			gram.x_size=dec2num(&d); 
		GetDItem(theDialog, 5, &i, &h,&r);
		getitext(h, chaine); i=0; vp=0;
		str2dec(chaine, &i, &d, &vp); 
		if (vp)
			gram.y_size=dec2num(&d); 
		GetDItem(theDialog, 6, &i, &h,&r);
		getitext(h, chaine); i=0; vp=0;
		str2dec(chaine, &i, &d, &vp); 
		if (vp)
			gram.x_resolution = dec2num(&d) / gram.x_size; 
		GetDItem(theDialog, 7, &i, &h,&r);
		getitext(h, chaine); i=0; vp=0;
		str2dec(chaine, &i, &d, &vp); 
		if (vp)
			gram.y_resolution = dec2num(&d) / gram.y_size; 
		h = GetResource(RES3_TYPE, 0);
		if(h) {
			HLock(h);
			(*(FLOAT**) h)[0]=gram.x_size;
			(*(FLOAT**) h)[1]=gram.y_size;
			(*(FLOAT**) h)[2]=gram.x_resolution;
			(*(FLOAT**) h)[3]=gram.y_resolution;
			HUnlock(h); 
			ChangedResource(h); 
			HPurge(h);
		}
		if (main_faite > 1 ) // *** tester avec le tiers au lieu de la moitie
			for (i=0; i < 10; i++) 
				gram.mid_fingers[i] = (hand[i] + hand[i+10])/2;
	}
	CloseDialog(theDialog); SetPort(savePort);
}

void 
FENETRE_SET :: RemoveCurrent ()
{
	if (CurClass) {
		CheckItem (LeMenu, CurItem, false);
		DelMenuItem (LeMenu, CurItem);
		SetPort ((GrafPtr) &Fen);
		EraseRect (&Fen.port.portRect);
		GEST_EXAMPLE* tamp = CurClass->Examples;
		while (tamp) {
			tamp->Supprime();
			tamp = tamp->Suivant;
		}
		RmveResource (CurClass->Res);
		CurClass->Res = NULL;
		Change = 1;
		delete CurClass;
		CurClass = NULL;
		NbChamps--;
	}
}
		
void 
FENETRE_SET :: Menu (int theItem) 
{
		Str255 ch; 
		if (LeFichier) UseResFile (LeFichier);
		switch (theItem) {
			case 0: return;
			case AjoutChampId : ChangeChamp ((Str255) NULL, 0); break;
			case EnleveChampId : RemoveCurrent (); break;
			case ResolutionId : Resolution(); break;
			case DebutId	: if (CurClass) CurClass->SaisieParams("\pdbut", CurClass->Params, true); break;
			case FinId : if (CurClass) CurClass->SaisieParams ("\pfin", CurClass->Params, false); break;
			default : 
				GetItem (LeMenu, theItem, ch);
				ChangeChamp (ch, theItem);
		}
} 

GEST_CLASS :: GEST_CLASS (FENETRE_SET* Doc, Handle h, Str255 name) 
: Res(h), Examples (NULL), Current(NULL), ExamplesList (NULL) 
{
		int i;
		Cell p;
		char buffer[255];
		Rect r1, r2;
		if (Res) {
			short *offset;
			nExamples = (short)  (GetHandleSize (Res) - sizeof(DtgConfig))/sizeof(short);
			Params = **((DtgConfig**) Res);
			SetRect (&r1, 0,  0, 166,  200);
			SetRect (&r2, 0, 0, 1, nExamples);
			p.h = 150; p.v = 15;
			ExamplesList = LNew (&r1, &r2, p, 0, (GrafPtr) &(Doc->Fen), true, true, false, true);
			
			HLock (Res);
			offset = (short*) ( ((char*) *Res) + sizeof (DtgConfig));
						// *** prions pour que la taille de DgtConfig soit paire...
			for ( i = 0; i < nExamples; i++) {
					p.h=0; p.v = i;
					numtostring(i, buffer);
					LSetCell ((Ptr) buffer, strlen(buffer), p, ExamplesList);
					Current = new GEST_EXAMPLE (&Doc->gram, this, *offset++);
			}
			HUnlock (Res);
		} else {
				UseResFile (Doc->LeFichier);
				nExamples = 0;
				Params.id = Doc->NbChamps;
				SetRect (&r1, 0,  0, 166,  200);
				SetRect (&r2, 0, 0, 1, nExamples);
				p.h = 150; p.v = 15;
				ExamplesList = LNew (&r1, &r2, p, 0, (WindowPtr) &(Doc->Fen), true, true, false, true);
				for (i  =0; i <= name[0] ; i++) 
						Params.nom[i] = name[i];
				Params.start.wrist = Params.end.wrist = isWest;
				for (i=0; i<5; i++)
					Params.start.fingers[i] = Params.end.fingers[i] = isBent;
				Params.start.position.h  = 0;
				Params.start.position.v = 0;
				Params.start.use_position = false;
				Res = NewHandle (sizeof(DtgConfig));
				**((DtgConfig**) Res) = Params;
			AddResource (Res, RES1_TYPE, UniqueID (RES1_TYPE), name);
			UpdateResFile(Doc->LeFichier);
		}
		LDoDraw (true, ExamplesList);
		Dessine (Doc);
}
			
GEST_CLASS :: ~GEST_CLASS () 
{ 
			if (Params.nom[0]) Enregistre ();
			GEST_EXAMPLE* tamp = Examples;
			while (tamp) {
						tamp = Examples->Suivant;
						delete Examples;
if (MemError()) Debugger();
						Examples = tamp;
				}
			if (Res) HPurge(Res);
			LDispose (ExamplesList);
}

void  
GEST_CLASS :: Name (Str255 name)
{
		if (Res) {
				short i; ResType t;
				GetResInfo (Res, &i, &t, name);
		}
}

int 
GEST_CLASS :: Dessine (FENETRE_SET* Doc) 
{ 
	if (Doc->Fen.port.visRgn) {
		LUpdate (Doc->Fen.port.visRgn, ExamplesList);
	} else { 
		RgnHandle r = NewRgn();
		RectRgn (r, &(Doc->Fen.port.portRect));
		LUpdate (r, ExamplesList);
		DisposeRgn(r);
	}
	FrameRect (&((*ExamplesList)->rView));
	return MAXSHORT;
}

void 
GEST_CLASS :: Touche (FENETRE_SET* Doc, EventRecord* e) 
{ 
		if (Current && ((e->message & 0x000000FF) == 8)) { 
			int i=0;	
			for (GEST_EXAMPLE * g = Examples; g; g=g->Suivant, i++)
				if (Current==g) break;
			LDelRow(1, i, ExamplesList); 
			Current->Supprime();
			delete Current;
			nExamples--;
			Current = 0;
		} else if ((e->what == keyDown) && (e->message & 0x000000FF) == 32) {
			Current = new GEST_EXAMPLE (&Doc->gram, this, 0);
			Cell p; 
			char buffer[255]; 
			p.h=0; p.v = nExamples;
			numtostring(nExamples, buffer);
			LAddRow (1, nExamples, ExamplesList);
			nExamples++;
			LSetCell ((Ptr) buffer, strlen(buffer), p, ExamplesList);
		} else if ((e->message & 0x000000FF) == 3) {
			Str255 s;
			NumToString (e->message, s);
			DebugStr (s);
		}
}

void 
GEST_CLASS :: Clique (FENETRE_SET*, EventRecord* e)  
{ 
		(void) LClick (e->where, e->modifiers, ExamplesList);
		Cell c = LLastClick (ExamplesList);
		if (c.v >=0) {
			GEST_EXAMPLE* t = Examples;
			for (int i=0; i < c.v && t; i++) 
				t= t->Suivant;
			Current = t;
		}
}

void 
GEST_CLASS :: MenuEdition (FENETRE_SET*, short) 
{ 
}

void 
GEST_CLASS :: Enregistre () 
{ 
	if (Res) {
			short* offset;
			**((DtgConfig**) Res) = Params;
			HUnlock(Res);
			SetHandleSize (Res, sizeof (DtgConfig) + sizeof(short) * nExamples);
			GEST_EXAMPLE* tamp = Examples;
			HLock(Res);
			offset = (short*) (((char*) *Res) + sizeof (DtgConfig));
			while (tamp) {
						*offset++ = tamp->Enregistre ();
if (MemError()) Debugger();
						tamp=tamp->Suivant;
			}
			HUnlock(Res);
			ChangedResource (Res);
if (ResError()) Debugger();
		}
}

void 
GEST_CLASS :: SaisieParams (Str255 name, DtgConfig& c, Boolean start) 
{ 
	GrafPtr 	savePort; 
	DialogPtr	theDialog; 
	short itemHit, i, j; 
	Handle h; 
	Rect r;
	Str255 chaine;  
	
	GetPort(&savePort);
	theDialog = GetNewDialog(ParamsDialogue, nil, (WindowPtr) -1); 
	ParamText(name, (Str255) NULL, (Str255) NULL, (Str255) NULL);
	
// lecture des parametres
	if (start) {
		for (j = 0; j < 5; j++) {
			GetDItem(theDialog, j+3, &i, &h,&r);
			if (c.start.fingers[j] == isBent || c.start.fingers[j] == is01)
				SetCtlValue((ControlHandle) h, 1);
			else SetCtlValue((ControlHandle) h, 0);
			if (j >0) {
				GetDItem(theDialog, j+17, &i, &h,&r);
				if (c.start.fingers[j] == isBent || c.start.fingers[j] == is10)
					SetCtlValue((ControlHandle) h, 1);
				else SetCtlValue((ControlHandle) h, 0);
			}
		}
		for (j = 0; j < 7; j++) {
			GetDItem(theDialog, j+9, &i, &h,&r);
			if (j==(int) c.start.wrist)
				SetCtlValue((ControlHandle)h, (int) 1);
			else SetCtlValue((ControlHandle)h, (int) 0);
		}	
		GetDItem(theDialog, 16, &i, &h,&r);
		SetCtlValue((ControlHandle) h, (int) c.start.use_position);
	}else {
		for (j = 0; j < 5; j++) {
			GetDItem(theDialog, j+3, &i, &h,&r);
			if (c.end.fingers[j] == isBent || c.end.fingers[j] == is01)
				SetCtlValue((ControlHandle) h, 1);
			else SetCtlValue((ControlHandle) h, 0);
			if (j >0) {
				GetDItem(theDialog, j+17, &i, &h,&r);
				if (c.end.fingers[j] == isBent || c.end.fingers[j] == is10)
					SetCtlValue((ControlHandle) h, 1);
				else SetCtlValue((ControlHandle) h, 0);
			}
		}
		for (j = 0; j < 7; j++) {
			GetDItem(theDialog, j+9, &i, &h,&r);
			if (j==(int) c.end.wrist)
				SetCtlValue((ControlHandle)h, (int) 1);
			else SetCtlValue((ControlHandle)h, (int) 0);
		}	
		GetDItem(theDialog, 16, &i, &h,&r);
		SetCtlValue((ControlHandle) h, 0);
	}
	
// Dialogue								
	ShowWindow(theDialog); SetPort(theDialog);
	
	do { 
		ModalDialog(NULL, &itemHit);
		if( itemHit > 2 && itemHit <= 21) { // mise a jour des controles
			 if (itemHit > 8 && itemHit <16) {
			 	for (j=9; j < 16; j++) {
					GetDItem(theDialog, j, &i, &h,&r);
					SetCtlValue((ControlHandle)h, 0);
				}
				GetDItem(theDialog, itemHit, &i, &h,&r);
				SetCtlValue((ControlHandle) h, 1);
			} else if (itemHit != 17) {
				GetDItem(theDialog, itemHit, &i, &h,&r);
				if (GetCtlValue((ControlHandle) h)==1) SetCtlValue((ControlHandle) h, 0);
				else SetCtlValue((ControlHandle) h, 1);
			}
		}
	} while ((itemHit != 1) && (itemHit != 17));
	
// ecriture des parametres	
	if (itemHit == 1) { 
		if (start) {
			for (j = 0; j < 5; j++) {
				FingerBend tamp;
				GetDItem(theDialog, j+3, &i, &h,&r);
				if (GetCtlValue ((ControlHandle) h)) tamp = isBent; 
				else tamp = isStraight;
				if (j >0) {
					GetDItem(theDialog, j+17, &i, &h,&r);
					if (GetCtlValue ((ControlHandle) h)) {
						if (tamp != isBent) tamp = is01; 
					}else if (tamp != isStraight) tamp = is10;
				}
				c.start.fingers[j]=tamp;
				}
				for (j = 0; j < 7; j++) {
					GetDItem(theDialog, j+9, &i, &h,&r);
					if (GetCtlValue((ControlHandle)h)) {
						c.start.wrist = (WristOrientation) j; break;
					}
				}	
				GetDItem(theDialog, 16, &i, &h,&r);
				c.start.use_position= (Boolean) GetCtlValue((ControlHandle) h);
		}else {
			for (j = 0; j < 5; j++) {
				FingerBend tamp;
				GetDItem(theDialog, j+3, &i, &h,&r);
				if (GetCtlValue ((ControlHandle) h)) tamp = isBent; 
				else tamp = isStraight;
				if (j >0) {
					GetDItem(theDialog, j+17, &i, &h,&r);
					if (GetCtlValue ((ControlHandle) h)) {
						if (tamp != isBent) tamp = is01; 
					}else if (tamp != isStraight) tamp = is10;
				}
				c.end.fingers[j]=tamp;
			}
			for (j = 0; j < 7; j++) {
				GetDItem(theDialog, j+9, &i, &h,&r);
				if (GetCtlValue((ControlHandle)h)) {
					c.end.wrist = (WristOrientation) j; 
					break;
				}
			}	
		}
	}
	CloseDialog(theDialog); SetPort(savePort);
}

#define EXTENT_BUF 100

GEST_EXAMPLE :: GEST_EXAMPLE (DtgGrammar* gram, GEST_CLASS* c, short res)
{
	Parent = c; Length = 0;
	Parent->Current = this;
	Suivant = Parent->Examples;
	Parent->Examples = this;
	vectors.suivant=NULL;
	vectors.vector=NULL;
	if (res) {
			Res = GetResource(RES2_TYPE, res);
			if (Res) 
				Length = (int) GetHandleSize (Res)/sizeof (DTG_POINT);
	} else {
				EventRecord evt;
				Res= NewHandle (EXTENT_BUF*sizeof(DTG_POINT));
				HLock(Res);
				DTG_POINT* p = (DTG_POINT*) *Res;
				DtgRecord rec;
				DtgHand hand;
				Length = 0;
				while (!OSEventAvail(keyUpMask,&evt)) {
					if (DtgContinuous (&dtglink, &rec)) {
						if (DtgProject (gram, &rec, &hand)) {
						// set cursor (hand) ? ***
							p[Length] = DTG_POINT (hand.x, hand.y, hand.z, hand.fingers, hand.time);
							PutMouse (hand.x, hand.y);
							Length++;
							if (Length % EXTENT_BUF)  { 
								HUnlock(Res);
								SetHandleSize (Res, GetHandleSize(Res)+EXTENT_BUF*sizeof(DTG_POINT));
								HLock(Res);
								p = (DTG_POINT*) *Res;
							}
						} else break;
						}
				}
				HUnlock(Res);
				SetHandleSize (Res, Length*sizeof(DTG_POINT));
if (MemError()) Debugger();
				Str255 ch;
				ch[0]=0;
				AddResource (Res, RES2_TYPE, UniqueID (RES2_TYPE), ch);
if (ResError()) Debugger();
	}
}

GEST_EXAMPLE :: ~GEST_EXAMPLE ()
{
			if (Res) HPurge (Res);
			if (vectors.vector)
				FreeVector(vectors.vector);
			if (Parent->Examples == this) Parent->Examples = Suivant;
			else {
				GEST_EXAMPLE* ex = Parent->Examples;
				while (ex  && ex->Suivant != this) ex=ex->Suivant;
				if (ex) ex->Suivant = Suivant;
			}
}

short 
GEST_EXAMPLE :: Enregistre ()
{
	if (Res) {
		ChangedResource (Res);
		short i; ResType t; Str255 name;
		name[0]=0;
		GetResInfo (Res, &i, &t, name);
		return i;
	} else return 0;
}

void 
GEST_EXAMPLE :: Supprime ()
{
	if (Res) {
		RmveResource (Res);
		Res=0;
	}
}

DTG_POINT :: DTG_POINT (short a, short b, short c, FingerBend* f, long i)
: x(a), y(b), z(c), tc (i)
{
	for (int j =0; j<5; j++) fingers[j] = f[j];
}

void 
FENETRE_SET :: Teste ()
{ 
	DtgRecord curpos;
	DtgResult curgest;
	Rect r;
	short i, j;
	Analyse (0);
	SetPort ((GrafPtr)&Fen);
	i = 15; j=200;
	TextFace (bold);
	while( ! Button()) {
			SystemTask();
			if (DtgContinuous (&dtglink, &curpos)) 
					if (DtgParseGesture (&gram, &curpos, &curgest)) {
							MoveTo (j, i);
							DrawString(curgest.name);
							if (i > 350) {j += 75; i = 15; }
							else i+=20;
			}
	}
	SetRect (&r, 200, 0, 350, 500);
	TextFace (normal);
	EraseRect (&r);
}

void 
FENETRE_SET :: ShowValues ()
{ 
	DtgRecord curpos;
	DtgHand hand, oldhand;
	int i, j;
	Rect r;
	Point p;
	int h[10];
	Str255 s;
	
	SetPort ((GrafPtr)&Fen);
	oldhand.wrist = (WristOrientation) 8;
	SetRect (&r, 200, 0, 500, 300);
	EraseRect (&r);
	PenSize (2, 2);
	for (i =0; i < 10; i++)
		h[i]=gram.mid_fingers[i];
	TextMode (srcCopy);
	PenMode (srcCopy);
	for (i =0; i < 10; i++) {
				p.h= (i/2)*50 + 250;
				p.v= 175 + (i%2)*20;
				SetRect (&r,  p.h , p.v - 15, p.h + 45, p.v + 5 );
				EraseRect (&r);
				MoveTo (p.h , p.v);
				j=h[i];
				s[0]=0;
				NumToString (j, s);
				DrawString (s);
		}
	while( !Button()) {
			SystemTask();
			if (DtgContinuous (&dtglink, &curpos)) 
					if (DtgProject (&gram, &curpos, &hand)) {
							if (hand.x != -1)
								PutMouse (hand.x, hand.y);
							for (i =0; i < 10; i++)
								if (h[i] != curpos.flex[i]) {
									p.h= (i/2)*50 + 250;
									p.v= 175 + (i%2)*20;
									SetRect (&r,  p.h , p.v - 15, p.h + 45, p.v + 5 );
									EraseRect (&r);
									MoveTo (p.h , p.v);
									h[i] = curpos.flex[i];
									j=h[i];
									s[0]=0;
									NumToString (j, s);
									DrawString (s);
								}
							if (oldhand.wrist != hand.wrist) {
								oldhand.wrist = hand.wrist;
								SetRect (&r, 300, 200, 400, 300);
								EraseRect (&r);
								switch (hand.wrist) {
									case isWest : p.h = 400; p.v = 250; break;
									case isNWest : p.h = 400; p.v = 200; break;
									case isNorth : p.h = 350; p.v = 200; break;
									case isNEast : p.h = 300; p.v = 200; break;
									case isEast : p.h = 300; p.v = 250; break;
									case isSEast : p.h = 300; p.v = 300; break;
									case isSouth : p.h = 350; p.v = 300; break;
								}
								MoveTo (350, 250);
								LineTo (p.h, p.v);
							}
							for (i =0; i < 5; i++) {
								if (oldhand.fingers[i]!=hand.fingers[i]) {
									oldhand.fingers[i]=hand.fingers[i];
									p.h = i*50 + 250;
									SetRect (&r, p.h -4, 0, p.h + 4, 150);
									EraseRect (&r);
									switch (hand.fingers[i]) {
										case isStraight :  p.v = 0; break;
										case is01 : p.v = 50; break;
										case is10 :  p.v =100; break;
										case isBent :  p.v = 150; break;
									}
									MoveTo (p.h, 150);
									LineTo (p.h, p.v);
									MoveTo (p.h - 4, 50);
									LineTo (p.h + 4, 50);
									MoveTo (p.h - 4, 100);
									LineTo (p.h + 4, 100);
								}
							}
			}
	}
	SetRect (&r, 200, 0, 500, 300);
	PenNormal();
	EraseRect (&r);
}