/* INCLUDE */

# include <Types.h> 				/* Nearly always required */
# include <QuickDraw.h> 			/* To access the qd globals */
# include <ToolUtils.h> 	
# include <Events.h>				/* GetNextEvent(), ... */
# include <OSEvents.h>
#include <Files.h>
#include <Menus.h>
#include <Packages.h>
#include <Windows.h>
#include <Dialogs.h>
# include <Strings.h>
# include <Devices.h>
# include <String.h>
# include <memory.h>	
# include <Resources.h>	
# include <desk.h>	
# include <scrap.h> 				/* not yet necessary */
# include <OSUtils.h>

# include "DtgDrvr.h"

#define gd(A) (((Data *) dCtl->dCtlStorage)->A)

OSErr DrvrInit (ParmBlkPtr, DCtlPtr);

pascal OSErr 
DRVROPEN (ParmBlkPtr ctlPB, DCtlPtr dCtl)
{
	WindowPtr myWindow;
	short refnum;
		
	if (dCtl->dCtlStorage == NULL) {
/* fenetre et donnees */
			ResrvMem(sizeof(Data) + sizeof (WindowRecord));
			dCtl->dCtlStorage = (Handle) NewPtr(sizeof(Data));
/*variables globales */
			refnum = (short) BitNot (dCtl->dCtlRefNum);
			gd(DriverID) =  ((short) (refnum << 5)) | (short) 0xC000; 
			myWindow = GetNewWindow(gd(DriverID), NULL, (WindowPtr) -1);
			if (myWindow) {
				((WindowRecord*) myWindow)->windowKind=dCtl->dCtlRefNum;
				dCtl->dCtlWindow=myWindow; 
				ShowWindow (myWindow); 
				SetPort (myWindow);
				gd (hand_shown) = false;
				gd (testing) = false;
				gd(curtry)[0]=0;
			} else SysBeep(5);
			gd(isopen) = false;
			if (! DtgOpen(&gd(link), 'm', 0, 0, 0)) {
					DebugStr ("\pDtg : unable to open serial port correctly");
					return -1;
			}
			return DrvrInit (ctlPB, dCtl) ;
	} else return 0;
}

pascal OSErr 
DRVRCLOSE (ParmBlkPtr,  DCtlPtr dCtl) 
{
	 if (gd(isopen)) {
		DtgClose (&gd(link));
		if (gd(isopen))
			DtgFreeGrammar(&gd(grammar));
		DeleteMenu(gd (DriverID));
		DrawMenuBar();
		if (dCtl->dCtlWindow)		
				DisposeWindow((WindowPtr) dCtl->dCtlWindow);
		dCtl->dCtlWindow=NULL;
		DisposPtr((Ptr) (dCtl->dCtlStorage));
		dCtl->dCtlStorage=NULL;
	}
	return MemError();
}
			
OSErr 
DrvrInit (ParmBlkPtr, DCtlPtr dCtl) 
{
		OSErr test; 
		short f; 
		Str255 s1;
		Point p; 
		SFTypeList typelist; 
		SFReply Reply;
		
		if (gd(isopen)) { 
			DtgReset (&gd(link), 0);
			DtgFreeGrammar(&gd(grammar));
			gd(isopen) = false;
		}
		p.h=100; p.v=60;	typelist[0]='Gest'; 
		s1[0]=0;
		SFGetFile (p, s1, NULL, 1, typelist, NULL, &Reply);
		if (Reply.good) {
					test=SetVol(NULL, Reply.vRefNum);
					test=FSOpen (Reply.fName, Reply.vRefNum, &f);
					if(test) return -1; 
					if (DtgLoadGrammar(&gd(grammar), f)) {
						gd(isopen) = true;
						test = FSClose(f); 
						return noErr;
					}
					test = FSClose(f); 
		}
		return -1;
}

void 
DrawHand (DCtlPtr dCtl)
{
	GrafPtr savePort; 
	int i;
	Rect r;
	Point p;
	if (dCtl->dCtlWindow && gd(isopen)) {
	DtgHand* curhand = &(gd (grammar).curhand);
	GetPort(&savePort);
	SetPort (dCtl->dCtlWindow);
	PenSize (2, 2);
	if (gd(oldhand).wrist != curhand->wrist) {
		gd(oldhand).wrist = curhand->wrist;
		SetRect (&r, 0, 60, 100, 120);
		EraseRect (&r);
		switch (curhand->wrist) {
			case isWest : p.h = 100; p.v = 90; break;
			case isNWest : p.h = 100; p.v = 60; break;
			case isNorth : p.h = 50; p.v = 60; break;
			case isNEast : p.h = 0; p.v = 60; break;
			case isEast : p.h = 0; p.v = 90; break;
			case isSEast : p.h = 0; p.v = 120; break;
			case isSouth : p.h = 50; p.v = 120; break;
		}
		MoveTo (50, 90);
		LineTo (p.h, p.v);
	}
	for (i =0; i < 5; i++) {
			if (gd(oldhand).fingers[i]!=curhand->fingers[i]) {
					gd(oldhand).fingers[i]=curhand->fingers[i];
					p.h = i*15 + 15;
					SetRect (&r, p.h - 4, 0, p.h + 4, 60);
					EraseRect (&r);
					switch (curhand->fingers[i]) {
						case isStraight :  p.v = 0; break;
						case is01 : p.v = 20; break;
						case is10 :  p.v = 40; break;
						case isBent :  p.v = 60; break;
					}
					MoveTo (p.h, 60);
					LineTo (p.h, p.v);
					MoveTo (p.h - 4, 40);
					LineTo (p.h + 4, 40);
					MoveTo (p.h - 4, 20);
					LineTo (p.h + 4, 20);
			}
	}
	if (gd(test_to_redraw)) {
		Str255 tamp;
		NumToString (gd(tries), tamp);
		SetRect (&r, 0, 130, 200, 170);
		EraseRect (&r);
		MoveTo (10, 145);
		DrawString (tamp);
		MoveTo (30, 145);
		DrawString (gd(curtry));
		gd(test_to_redraw) = false;
	}
	SetPort(savePort);
	}
}

void
DoAbout (DCtlPtr dCtl)
{
	GrafPtr 	savePort; DialogPtr	theDialog; short itemHit;

	GetPort(&savePort);
	theDialog = GetNewDialog(gd(DriverID), nil, (WindowPtr) -1); 
	if (theDialog) {
		ShowWindow(theDialog);
		SetPort(theDialog);
		do { ModalDialog(nil, &itemHit); } while (itemHit != 1);
		CloseDialog(theDialog); 
		SetPort(savePort);
	}else SysBeep (5);
}

void
ToggleHand (DCtlPtr dCtl, Boolean should_show)
{
	if (should_show)
		gd (hand_shown) = true;
	else 
		gd (hand_shown) = false;
}

void 
LaunchTest (DCtlPtr dCtl)
{
		OSErr test; 
		short f, i; 
		ResType t;
		Str255 s1;
		Handle h;
		Point p; 
		SFTypeList typelist; 
		SFReply Reply;

		p.h=100; p.v=60;	typelist[0]='Gest'; 
		s1[0]=0;
		SFGetFile (p, s1, NULL, 1, typelist, NULL, &Reply);
		if (Reply.good) {
					test=SetVol(NULL, Reply.vRefNum);
					test = CurResFile();
					gd (resfile) = OpenResFile (Reply.fName);
if (gd(resfile)== 0)
Debugger();
					gd (testing) = true;
					gd (tries)=0;
					gd (succeed)=0;
					gd(test_to_redraw) = true;
					gd (nexamples) = Count1Resources ('GEST');
					gd(curtry)[0]=0;
					do {
						i = (Random () % gd(nexamples)) +1;
						h = Get1IndResource('GEST', i);
						if (h) GetResInfo (h, &f, &t, gd(curtry));
						else Debugger();
					} while(gd(curtry)[0]==0);
					DrawHand (dCtl);
					UseResFile (test);
		}
}

void 
AddTest (DCtlPtr dCtl,  DtgResult* curgest)
{
	short f, i, test; 
	ResType t;
	Handle h;
	gd(tries)++;
	if (! IUCompString (gd(curtry), curgest->name))
		gd(succeed)++;
	if (gd(tries) >= 50) {
		int j;
		Str255 tamp;
		NumToString (gd(succeed), gd(curtry));
		NumToString (gd(tries), tamp);
		j = gd(curtry)[0]+2;
		gd(curtry)[j++] = '/';
		for (i=0; i <= tamp[0]; i++, j++)
			gd(curtry) [j] = tamp[i+1]; 
		gd(curtry)[0] = j-1;
		gd (testing) = false;
		gd(test_to_redraw) = true;
		DrawHand (dCtl);
		CloseResFile(gd (resfile));
		return;
	}
	test = CurResFile();
	UseResFile (gd (resfile));
	gd(test_to_redraw) = true;
	gd(curtry)[0]=0;
	do {
		i = (Random () % gd(nexamples)) +1;
		h = Get1IndResource('GEST', i);
		if (h) GetResInfo (h, &f, &t, gd(curtry));
		else Debugger();
	} while(gd(curtry)[0]==0);
	DrawHand (dCtl);
	UseResFile (test);
}

void 
Recalibrate (DCtlPtr dCtl)
{
	GrafPtr savePort; DialogPtr	theDialog; 
	short itemHit, i, vp, main_faite=0;
	int hand[20];
	DtgRecord m;
	Handle h;
	Rect r;
	decform f;
	decimal d;
	char chaine[255];  
	extended tamp;
	
	if (! gd(hand_shown)) ToggleHand (dCtl, true);
	
	GetPort(&savePort);
	theDialog = GetNewDialog(gd(DriverID) +1, nil, (WindowPtr) -1); 
	if (theDialog) {
		f.style = FIXEDDECIMAL;
		f.digits = 3; // *** pour l'instant ca buggue quand on compile avec la lib 68881
		tamp=gd(grammar).x_size;
		num2dec(&f, tamp , &d); 
		dec2str(&f, &d, chaine); 
		GetDItem(theDialog, 4, &i, &h,&r);
		setitext (h, chaine);
		tamp=gd(grammar).y_size;
		num2dec(&f, tamp , &d); 
		dec2str(&f, &d, chaine); 
		GetDItem(theDialog, 5, &i, &h,&r);
		setitext (h, chaine);
		tamp=gd(grammar).x_size*gd(grammar).x_resolution;
		num2dec(&f, tamp, &d); 
		dec2str(&f, &d, chaine); 
		GetDItem(theDialog, 6, &i, &h,&r);
		setitext (h, chaine);
		tamp=gd(grammar).y_size*gd(grammar).y_resolution;
		num2dec(&f, tamp, &d); 
		dec2str(&f, &d, chaine); 
		GetDItem(theDialog, 7, &i, &h,&r);
		setitext (h, chaine);	
		// *** ajouter l'offset ***
		
			ShowWindow (theDialog);
			SetPort(theDialog);
			
			do { 
				ModalDialog(nil, &itemHit);
				if (itemHit>=12) {
				 long t = TickCount() + 60*10;
				while (! DtgContinuous (&gd(link), &m) && (TickCount() < t)); 
				if (TickCount() >= t) DtgError ("\pno response", 0);
				else {
					if (itemHit==12) { // main fermee
						for (i=0; i<10; i++)
							hand[i]=m.flex[i];
					} else { // main ouverte
						for (i=0; i<10; i++)
							hand[i+10]=m.flex[i];
					}
					main_faite++;
				}
			}
		} while (itemHit > 2);
			
		if (itemHit == 1) { 
			GetDItem(theDialog, 4, &i, &h,&r);
			getitext(h, chaine); i=0; vp=0;
			str2dec(chaine, &i, &d, &vp); 
			if (vp)
				gd(grammar).x_size=dec2num(&d); 
			GetDItem(theDialog, 5, &i, &h,&r);
			getitext(h, chaine); i=0; vp=0;
			str2dec(chaine, &i, &d, &vp); 
			if (vp)
				gd(grammar).y_size=dec2num(&d); 
			GetDItem(theDialog, 6, &i, &h,&r);
			getitext(h, chaine); i=0; vp=0;
			str2dec(chaine, &i, &d, &vp); 
			if (vp)
				gd(grammar).x_resolution = dec2num(&d) / gd(grammar).x_size; 
			GetDItem(theDialog, 7, &i, &h,&r);
			getitext(h, chaine); i=0; vp=0;
			str2dec(chaine, &i, &d, &vp); 
			if (vp)
				gd(grammar).y_resolution = dec2num(&d) / gd(grammar).y_size; 
			if (main_faite > 1 ) // *** tester avec le tiers au lieu de la moitie
				for (i=0; i < 10; i++) 
					gd(grammar).mid_fingers[i] = (hand[i] + hand[i+10])/2;
		}
		CloseDialog(theDialog); 
		SetPort(savePort);
	}else SysBeep (5);
}
			
pascal OSErr 
DRVRCONTROL (ParmBlkPtr ctlPB, DCtlPtr dCtl) 
{
	short test; 
	EventRecord* evt;
	
	switch(ctlPB->cntrlParam.csCode) {
			case accEvent: 
					evt = (EventRecord*) *((long*) &(ctlPB->cntrlParam.csParam[0]));
					switch (evt->what) {
						case updateEvt:
							if (dCtl->dCtlWindow && gd(isopen)) {
								SetPort (dCtl->dCtlWindow);
								gd(test_to_redraw) = true;
								BeginUpdate (dCtl->dCtlWindow);
									if (gd(hand_shown))  DrawHand (dCtl);
								EndUpdate (dCtl->dCtlWindow);
							}
							break;
						case activateEvt : 
							if (evt->modifiers & activeFlag) {
								MenuHandle m = GetMenu (gd(DriverID));
								if (m) {
									dCtl->dCtlMenu = gd(DriverID);
									InsertMenu (m, 0);
									DrawMenuBar();
								} else SysBeep(5);
							} else {
								DeleteMenu(gd(DriverID));
								DrawMenuBar();
							}
						default :	break;
					} break;
			case accRun:
					if (gd(isopen)) {
						if (DtgContinuous (&gd(link), &gd(curpos))) {
							if (DtgParseGesture (&gd(grammar), &gd (curpos), &gd(curgest))) {
// DebugStr (gd(curgest).name);
									if (gd(testing)) {
										AddTest (dCtl, &gd(curgest));
									} else {
									test = PostEvent (keyDown, 0x24c03); 
									// *** warning : only shure with apple ADB extended Keyboard
									test = PostEvent (app2Evt, (long) &gd(curgest));
									}
							}
							if (gd(hand_shown)) DrawHand (dCtl);
							}
						} break;
			case accCursor: break;
			case accMenu: SetPort (dCtl->dCtlWindow);
				switch (ctlPB->cntrlParam.csParam[1]) {
				case 1 : DoAbout (dCtl); break;
				case 3 : return DrvrInit (ctlPB, dCtl); // *** do this with caution !!
				case 4 : if (gd(isopen)) Recalibrate (dCtl); 
							else SysBeep(5); break;
				case 5: ToggleHand (dCtl, ! gd(hand_shown)); break;
				case 6 : LaunchTest(dCtl);
				default : break;
				} 
				HiliteMenu(0);
				break;
			case accUndo: 
			case accCut: 
			case accCopy:  
			case accPaste: 
			case accClear: 
			default : break;
		} 
	return noErr; 
}

pascal OSErr 
DRVRPRIME (ParmBlkPtr,  DCtlPtr)
{
	return noErr;
}

pascal OSErr 
DRVRSTATUS (ParmBlkPtr,  DCtlPtr) 
{
	return noErr;
}
