

#include "Types.r"				/* To get system types */
#include "MPWTypes.r"			/* To get 'DRVW' type */

type 'DRVR' as 'DRVW';			/* Map 'DRVW' => 'DRVR' */

/*
 * This will produce a DRVR resource from the special DRVW type.
 *
 * Note that the ID 12 is irrelevant, since the Font/DA Mover
 * will renumber it to something else when installing it anyway.
 *
 * The leading NUL in the resource name is required to
 * conform to the desk accessory naming convention.
 *
 * The resource is declared purgeable.	If the code were to
 * do funky things like SetTrapAddress calls (requiring the code to
 * be around at all times), we would have to set it nonpurgeable.
 */

#define DriverID	12

resource 'DRVR' (DriverID, "\0x00Dtg", purgeable) {
	/*
	 * DRVR flags
	 */
	NeedLock,			/* not OK to float around, not saving ProcPtrs */
	NeedTime,		    	/* give us periodic Control calls */
	NeedGoodbye,		
	noStatusEnable,
	ctlEnable,				/* Desk accessories only do Control calls */
	noWriteEnable,
	noReadEnable,
	1,					    /* drvrDelay - Wake up every 1/60s seconds */
	updateMask + activMask /* +mDownMask+keyDownMask+autoKeyMask */, /* drvrEMask  */
	0,						/* drvrMenu */
	"Dtg",				/* drvrName - This isn't used by the DA */
	/*
	 * This directive inserts the contents of the DRVW resource
	 * produced by linking DRVRRuntime.o with our DA code
	 */
	$$resource("Dtg.DRVW", 'DRVW', 0)
};

/*
 * Since desk accessories cannot use global data (and the C compiler
 * considers string constants to be global data) and we really don't
 * want to hard-code strings in our source, the strings used by the 
 * DA are stored in the resource file. Note the expression used to
 * figure out the resource id.
 */

resource 'STR#' (-16000, "Erreurs", purgeable) {
	{
		"Problme  l'ouverture";
		"";
		"";
		"";
		"FSWrite";
		"FSRead";
		"";
		"";
		"ResourceMngr (Pb de mmoire)";
		"";
		"Fonction non implante";
		"Entres/Sortie";
		""
	};
};

