/***********************************************************************
   (C) Copyright, 1990 by Dean Rubine, Carnegie Mellon University
    Permission to use this code for noncommercial purposes is hereby granted.
    Permission to copy and distribute this code is hereby granted provided
    this copyright notice is retained.  All other rights reserved.
 **********************************************************************/

/*
 single path classifier
*/

#define	MAXSCLASSES	100

typedef int		    sClassIndex; /* single feature-vector class index */

struct sclassdope {
	Str255 		name;
	sClassIndex	number;
	Vector	average;
	Matrix	sumcov;
	int		nexamples;
};

typedef struct sclassdope  *sClassDope;	 /* single feature-vector class dope */

struct sclassifier {
	int		nfeatures;
	int		nclasses;
	sClassDope	*classdope;

	Vector		cnst;	/* constant term of discrimination function */
	Vector		*w;	/* array of coefficient weights */
	Matrix		invavgcov; /* inverse covariance matrix */
};

typedef struct sclassifier *sClassifier; /* single feature-vector classifier */

sClassifier	sNewClassifier (void);
void	 	sFreeClassifier (sClassifier);	
sClassDope  sAddClass(sClassifier, Str255);
void		sAddExample (sClassifier, Str255, Vector);
void		sRemoveExample (sClassifier, Str255, Vector);
void		sDoneAdding (sClassifier);	
sClassDope	sClassify (sClassifier, Vector);
sClassDope	sClassifyAD (sClassifier, Vector, FLOAT*, FLOAT*);
sClassDope	sClassNameLookup (sClassifier, Str255);
FLOAT		MahalanobisDistance (Vector, Vector, Matrix);

#ifdef MAC
Handle 		sCompile (sClassifier sc);
sClassifier	sLoad (Handle);
sClassifier	sRead (short);	
void		sWrite (sClassifier, short);
#else
sClassifier	sRead (FILE*);	
void		sWrite (FILE*, sClassifier);
#endif
