/***********************************************************************
   (C) Copyright, 1990 by Dean Rubine, Carnegie Mellon University
    Permission to use this code for noncommercial purposes is hereby granted.
    Permission to copy and distribute this code is hereby granted provided
    this copyright notice is retained.  All other rights reserved.
 **********************************************************************/

/*
 FV - computes and stores single-path feature vectors
 */

/* ---------- compile time settable parameters ----------  */
/* some of these can also be set at runtime, see fv.c */

#undef	USE_TIME	/*	 Define to enable the duration and maximum
				   velocity features.  When not defined, 0
				   may be passed as the time to FvAddPoint */

#define	DIST_SQ_THRESHOLD (3*3)	/* points within sqrt(DIST_SQ_THRESHOLD)
				   will be ignored to eliminate mouse jitter */

#define SE_TH_ROLLOFF	(4*4)	/* The SE_THETA features (cos and sin of angle
				   between first and last point) will be
				   be scaled down if the distance between the
				   points is less than sqrt(SE_TH_ROLLOFF) */

/* ---------------- -------------------- ------------------*/

// positions valides pour les doigts :
typedef enum { isStraight, is01, is10, isBent }FingerBend;

#define MAXFEATURES	32	/*  maximum number of features,
				    occasionally useful as an array bound */

// indices into the Vector returned by FvCalc

#define	PF_INIT_COS	0	// initial angle (cos) 
#define	PF_INIT_SIN	1	// initial angle (sin)
#define	PF_BB_LEN	2	// length of bounding box diagonal
#define	PF_BB_TH	3	// angle of bounding box diagonal
#define	PF_SE_LEN	4	// length between start and end points
#define	PF_SE_COS	5	// cos of angle between start and end points
#define	PF_SE_SIN	6	// sin of angle between start and end points
#define	PF_LEN		7	// arc length of path
#define	PF_TH		8	// total angle traversed
#define	PF_ATH		9	// sum of abs vals of angles traversed
#define	PF_SQTH		10	// sum of squares of angles traversed

#define	PF_DUR		11	// duration of path

#define PF_Z_AMPL	12	// max z - min z should be replaced by end - start ?
#define PF_Z_LEN	13	// total length on z axis

#define PF_T_AMPL	14 	// thumb
#define	PF_T_LEN	15

#define PF_I_AMPL	16 	// index
#define	PF_I_LEN	17

#define PF_M_AMPL	18 	// major
#define	PF_M_LEN	19

#define PF_AN_AMPL	20 	// annular
#define	PF_AN_LEN	21

#define PF_AU_AMPL	22 	// auricular
#define	PF_AU_LEN	23

#ifndef USE_TIME
#	define NFEATURES	24
#else
#	define	PF_MAXV		24	// maximum speed
#	define	NFEATURES	25
#endif

/* structure which holds intermediate results during feature
   vector calculation */

struct fv {
	/* the following are used in calculating the features */

	FLOAT		startx, starty; /* starting point */
	long		starttime;	/* starting time */

	/* these are set after a few points and left */
	FLOAT		initial_sin, initial_cos; /* initial angle to x axis */

	/* these are updated incrementatally upon every point */

	int		npoints;	/* number of points in path */

	FLOAT		dx2, dy2; 	/* differences: endx-prevx, endy-prevy */
	FLOAT		magsq2;		/* dx2*dx2 + dy2*dy2 */

	FLOAT		endx, endy; 	/* last point added */
	long		endtime;

	FLOAT		minx, maxx, miny, maxy;  /* bounding box */

	FLOAT		path_r, path_th; /* total length and rotation (in rads) */
	FLOAT		abs_th;		/* sum of absolute values of path angles */
	FLOAT		sharpness;	/* sum of squares of path angles */
	FLOAT		maxv;		/* maximum velocity */

	FLOAT		minz, maxz, path_z, last_z;
	FLOAT		minf[5], maxf[5], path_f[5], last_f[5];

	Vector		y;		/* Actual feature vector */
};

typedef struct fv *FV;		/* During gesture collection, an FV holds
				   all intermediate results used in the
				   calculation of a single feature vector */

FV	FvAlloc ();
void    FvFree (FV);
void	FvInit (FV);
void	FvAddPoint (FV, int, int, int, FingerBend*, long); /* fv, x, y, z, fingerpos [5], time */
Vector	FvCalc (FV);

/* 
  These functions are used as follows:

 	FV fv = FvAlloc();
	int x, y; long t; Vector v;

  FvAlloc() is typically called only once per program invocation.
  The typical loop to compute a feature vector as a gesture is read in is:

	FvInit(fv);
	while(GetNextPoint(&x, &y, &t) != END_OF_GESTURE)
		FvAddPoint(fv, x, y, t);
	v = FvCalc(fv);

  v may now be passed to sClassify to classify the gesture.
*/




