#ifndef __SERIAL__
#include <Serial.h>
#endif

typedef struct {
	short port_in;
	short port_out;
	short config;
	SerShk protocol;
	void* in_buffer;
	int in_buf_size;
	short continuous;
	char cmd_buf[26];
} DtgLink;

typedef struct {
	int flex[10];
	extended position [3];
	extended orientation [3];
} DtgRecord;


int DtgOpen (DtgLink*, char, short, short, short);
void DtgClose (DtgLink*);
int DtgWrite (DtgLink*, char, int);
int DtgRead (DtgLink*, char);

int DtgQuery (DtgLink*, DtgRecord*);
int DtgContinuous (DtgLink*, DtgRecord*);
int DtgReset (DtgLink*, short);

void  DtgError (Str255, int);
void PutMouse (short, short);

#define _ENGLISH
#undef _FRENCH

#ifdef _ENGLISH
#define dCorrectUse "Correct usage is: 'DtgInit'"
#define dMemProb "Memory Problem"
#define dGestSetnf "Dataglove not found"
#endif

#ifdef _FRENCH
#define dCorrectUse "la Syntaxe est: 'DtgInit'"
#define dMemProb "Problme de mmoire"
#define dGestSetnf "Dataglove non trouv"
#endif

