#include <Types.h>
#include <SANE.h>
/* for debug */
#include <QuickDraw.h>
#include <Windows.h>
#include <Files.h>
#include <memory.h>
#include <packages.h>
#include <Devices.h>
#include <Serial.h>

#include "DtgLink.h"

#define Repeat60  'A'
#define Repeat30 'B'
#define OneShot 'C'
#define DeltaSend 'L'
#define EmptyBuffer 'E'
#define ColdReset 'I'
#define SoftReset 'J'
#define SystemID 'D'
#define FlexValues 0x57
#define SetBright 0x4d
#define SetDim 0x4e
#define SetCutoff 0x56

void 
DtgError (Str255 c, int i)
{
	if (i) {
		Str255 d;
		NumToString (i, d);
		DebugStr (d);
	}
	else DebugStr (c);
}

int
DtgOpen (DtgLink* port, char use_port, short config, short use_dtr, short use_xon)
{
	short test;
	short *myptr;
	port->continuous = 0;
	if (! config) port->config = 10 - 16384 + 3072 ; // 0x6C0A default values for connection 10 - 16384 + 3072
	else port->config = config;
	port->protocol.evts=0; 
	if (use_dtr) port->protocol.fCTS = port->protocol.fDTR=1; 
	else port->protocol.fDTR = port->protocol.fCTS = 0; 
	if (use_xon) { 
			port->protocol.fXOn =1; 
			port->protocol.xOn=13; 
			port->protocol.xOff=14; 
			port->protocol.fInX=1;
	} else {
			port->protocol.fXOn =0; 
			port->protocol.xOn=0; 
			port->protocol.xOff=0; 
			port->protocol.fInX=0;
	}
	myptr = (short*) 0x206; /* var globale printer port = $207 */
	if (! *myptr % 2) use_port = 'm';
	myptr = (short*) 0x1FA; /*  SPConfig */
	if (*myptr % 2) use_port = 'm'; /*teste si Appletalk est install */
	
	if ( use_port =='m' ) {
		port->port_in = ainRefNum; port->port_out = aoutRefNum;
		test=OpenDriver ("\p.AIn", &(port->port_in));
if (test) Debugger();
		test=OpenDriver("\p.AOut", &(port->port_out));
if (test) Debugger();
		test=RamSDOpen(sPortA);
if (test) Debugger();
	} else {
		port->port_in = binRefNum; port->port_out = boutRefNum;
		test = OpenDriver ("\p.BIn", &(port->port_in));
		test = OpenDriver ("\p.BOut", &(port->port_out));
		test=RamSDOpen (sPortB);
if (test) Debugger();
	}
	if (test)
		{ Debugger(); return NULL; }
	else { // initialisation du port serie 
			port->in_buf_size = 1024;
			port->in_buffer = (Ptr) NewPtr (port->in_buf_size);
			test =SerSetBuf (port->port_in, (Ptr) port->in_buffer, port->in_buf_size);
if (test) DebugStr("\psersetbuf");
			test=SerReset(port->port_in, port->config); 
if (test) DebugStr("\preset in");
			test=SerReset(port->port_out, port->config); 
if (test) DebugStr("\preset out");
			test=SerHShake(port->port_in, &(port->protocol));  
if (test) DebugStr("\pshakein");
			test=SerHShake(port->port_out, &(port->protocol)); 
if (test) DebugStr("\pshake out");
			return 1;
	}
}

void 
DtgClose (DtgLink* port)
{
	short test;
	DtgReset (port, 0);
	test = KillIO (port->port_in); 
	test = KillIO (port->port_out);
	if (port->port_in == ainRefNum) 
		RamSDClose (sPortA);
	else RamSDClose (sPortB);
	if 	(port->in_buffer) DisposPtr ( (Ptr) port->in_buffer);
}

int
DtgRead (DtgLink* port, char wanted_msg)
{	
	int size;
	char read_msg;
	short test;
	port->cmd_buf[0]=0;
	size =1;
	while (port->cmd_buf[0] != '$') {
		test = FSRead (port->port_in, &size, port->cmd_buf);
		if (test) DtgError("\paligning DtgRead", test);
		size=1;
	}
	test = FSRead (port->port_in, &size, port->cmd_buf);
	read_msg = port->cmd_buf[0];
	if (test) DtgError("\preading command byte DtgRead", test);
	switch (read_msg) {
		case Repeat60 : 
		case Repeat30 : 
		case OneShot : size = 24; 
			break;
		case DeltaSend :  size = 3; break;
		case EmptyBuffer : size = 5; break;
		case ColdReset : 
		case SoftReset :
		case SystemID : size = 3; break;
		case 0xff :
		case 0xfe : size = 0;  break;
	}
	if (size) {
		test = FSRead (port->port_in, &size, port->cmd_buf);
		if (test) DtgError("\pgetting content DtgRead", test);
	}
	return read_msg == wanted_msg;
}

int
DtgWrite (DtgLink* port, char msg, int size)
{
	short test;
	port->cmd_buf[0]='$'; port->cmd_buf[1]=msg;
	size +=2;
	test = FSWrite (port->port_out, &size, port->cmd_buf);
	if (test)  DtgError ("\pWrite Error", msg);
	return size;
}

int
DtgTrans (char* buf, DtgRecord* ans)
{
	register int i;
	i = ((int) (buf[3])) * 255 + buf [2];
	ans->position [0] = ((extended) i) * 164.64 / 32767.0; 
	i = ((int) (buf[5])) * 255 + buf [4];
	ans->position [1] = ((extended) i) * 164.64 / 32767.0;
	i = ((int) (buf[7])) * 255 + buf [6];
	ans->position [2] = ((extended) i) * 164.64 / 32767.0;
	
	i = ((int) (buf [9])) * 255 + buf [8];
	ans->orientation [0] = ((extended) i) * 4.0 / 32768.0 ; /* mesure en radians entre -pi et pi */
	i = ((int) (buf [11] )) * 255 + buf [10];
	ans->orientation [1] = ((extended) i) * 4.0 / 32768.0;
	i = ((int) (buf [13] )) * 255 + buf [12];
	ans->orientation [2] =  ((extended) i) * 4.0 / 32768.0;
	for (i = 0 ; i < 10 ; i++) {
		ans->flex [i] = (int) (unsigned char) buf[i+14];
		}
	return buf[1]>=22;
}

int 
DtgQuery (DtgLink* port, DtgRecord* ans)
{
	if (port->continuous) DtgReset (port, true);
	port->cmd_buf[2] = 3;
	DtgWrite (port, OneShot, 1);
	if (DtgRead (port, OneShot))
		return DtgTrans (port->cmd_buf, ans);
	else return 0;
}

int 
DtgReset (DtgLink* port, short soft)
{
	if (soft) {
		DtgWrite (port, SoftReset,  0);
		DtgRead (port, SoftReset);
	} else {
		DtgWrite (port, ColdReset,  0);
		DtgRead (port, ColdReset);
	}
	port->cmd_buf[2] = 85;
	DtgWrite (port, SetDim, 1);
	port->cmd_buf[2] = 50;
	DtgWrite (port, SetBright, 1);
	port->cmd_buf[2] = 60;
	DtgWrite (port, SetCutoff, 1);
	port->continuous = 0;
	DtgWrite (port, FlexValues,  0);
	return 1;
}

int 
DtgContinuous (DtgLink* port, DtgRecord* ans)
{
	int avail = 0, good; 
	short test;
	if (! port->continuous) {
		port->continuous = 1;
		port->cmd_buf[2] = 3;
		DtgWrite (port, Repeat60, 1);
	}
	test = SerGetBuf (port->port_in, &avail);
	if (test) DtgError ("\pGetBuf Error", test);
	if  (avail >= 26) {
			do { 
				good=DtgRead (port, Repeat60);
				test = SerGetBuf (port->port_in, &avail);
				if (test) DtgError ("\pGetBuf Error", test);
			}while (avail >= 26); 
			if (good)
				return DtgTrans (port->cmd_buf, ans);
			else return 0;
	} else return 0;
}

void
PutMouse (short h, short v) 
{  
	register short* RawMouse = (short *) 0x82C ;
	if (h < 0 || v < 0) return;
	if (RawMouse[1] != h || RawMouse[0] != v) { 
	register char *CrsrNew  = (char*) 0x8CE; 
	register short* MouseAddr = (short *) 0x830;
	register short *MTemp = (short *) 0x828;
		RawMouse[1] = h;
		RawMouse[0] = v; 
		MTemp[1] = h;
		MTemp[0] = v; 
		MouseAddr[1] = h;
		MouseAddr[0] = v;
		*CrsrNew = 1;
	}
}
