/********************************************************
									FICHIER DTGANALYSE.H
********************************************************/


/* Types et fonctions utiliss pour reprsenter et manipuler la "grammaire" de gestes */


#ifndef _DtgAnalyse_h_
#define _DtgAnalyse_h_


#include <Values.h>
#include <Types.h>
#include <stdio.h>
#include <QuickDraw.h>
#include <SANE.h>
#include <Events.h>

#define FLOAT	extended

#include "bitvector.h"
#include "matrix.h"
#include "sc.h"	
#include "fv.h"
#include "DtgLink.h"	// contient le type DgtRecord


//-----------Les chiffres suivants dpendent de l'appli. et devront tre rgls-----------------

#define NWRIST	7	// nombre de positions possibles pour le poignet
#define NTHUMB	2	// de mme pour le pouce
#define NFINGER	4	// de mme pour les autres doigts

// positions valides pour le poignet:
typedef enum { isWest, isNWest, isNorth, isNEast, isEast, isSEast, isSouth } WristOrientation;

// distance entre deux points :

#define SQR(X)	((X)*(X))	
#define DISTANCE(A,B)  ((short)SQR(A.v-B.v)+SQR(A.h-B.h))

// STRUCTURES DE DONNEES

// ajout de configurations

typedef struct {
	WristOrientation wrist;
	FingerBend fingers[5];
	Point position;
	Boolean use_position;
	Boolean pad;
} DtgStartConfig;

typedef struct {
	WristOrientation wrist;
	FingerBend fingers[5];
} DtgEndConfig;

typedef struct fv_list {
	Vector vector;
	struct fv_list * suivant;
} FVList;

typedef struct  {
	int		id;
	Str255 nom;
	DtgStartConfig start;
	FVList* vectors;
	DtgEndConfig end;
} DtgConfig;

// representation interne de la main :

typedef struct {
	WristOrientation wrist;
	FingerBend fingers[5];
	Point point;
	unsigned long time;
	short x, y, z;
} DtgHand;

// Representation interne de la grammaire :

typedef struct dtg_config_wrist DtgConfigWrist;

typedef struct dtg_config_point {
	struct dtg_config_point * suivant;
	Point position;
	sClassifier gestures;
	DtgConfigWrist* end_confs[NWRIST];
} DtgConfigPoint;

typedef struct {
	int ngestures;
	DtgConfigPoint* gestures;	// liste de positions possibles
	DtgConfigPoint* nopos_gestures;
} DtgConfigAuricular;

typedef struct {
	DtgConfigAuricular* array[NFINGER];
} DtgConfigAnnular;

typedef struct {
	DtgConfigAnnular* array[NFINGER];
} DtgConfigMajor;

typedef struct {
	DtgConfigMajor* array[NFINGER];
} DtgConfigIndex;

typedef struct {
	DtgConfigIndex* array[NFINGER];
} DtgConfigThumb;

typedef struct dtg_config_wrist {
	DtgConfigThumb* array[NFINGER];
} DtgConfigWrist;

typedef struct {
	FLOAT x_size, x_resolution;	// pour la conversion en coordonnes d'cran
	FLOAT y_size, y_resolution;	// itou
	FLOAT x_offset, y_offset;
	int mid_fingers[10];
	// sommet de l'arbre reprsentant la grammaire :
	DtgConfigWrist* start_confs[NWRIST]; // configurations de debut de geste
	
	// variables utilises pendant la reconnaissance :
	DtgHand curhand;
	DtgConfigPoint* cur_gest;	// point de depart courant si is_running == true
 	FV current_fv;						// vecteur courant
	unsigned long last_gesture;		// temps du dernier geste reconnu
	int cur_cursor;
	Boolean is_running;		// dtection d'une reconnaissance en cours
#ifdef MAC
	Cursor idlecur, activecur;
#endif
} DtgGrammar;

// retour de la fonction DtgParseGesture
typedef struct {
	int id;
	StringPtr name;
	Point start;
	Point end;
	Rect Extent;
} DtgResult;

void DtgInitGrammar (DtgGrammar*); // initialise une grammaire
void DtgAddConfig (DtgGrammar*, DtgConfig*);	// ajoute une config.  la grammaire
void DtgCompile (DtgGrammar*);

void DtgSaveGrammar (DtgGrammar*, short);	// sauvegarde une grammaire sur disque
Boolean DtgLoadGrammar (DtgGrammar*, short);	// charge une grammaire en mmoire

Boolean DtgParseGesture (DtgGrammar*, DtgRecord*, DtgResult*);	// reconnait des gestes
Boolean DtgProject (DtgGrammar*, DtgRecord* , DtgHand*);

void DtgFreeGrammar (DtgGrammar*); // fermer une grammaire
void DtgEcho (DtgGrammar*, DtgHand*); // Afficher un echo lors de la reconnaissance

#endif

