/********************************************************
									FICHIER DTGANALYSE.C
********************************************************/
#include "DtgAnalyse.h"

#ifdef MAC
#include <Memory.h>
#include <Files.h>
#include <Quickdraw.h>
#include <SANE.h>
#include <Packages.h>
#include <CursorCtl.h>
#include <ToolUtils.h>

#define IOVARS \
	long size;\
	short test
#define WRITE(fd, sizev, data) \
		size = sizev;\
		test = FSWrite (fd, &size, (Ptr) data)
#define READ(fd, sizev, data)\
		size = sizev;\
		test = FSRead (fd, &size, (Ptr) data)

#define CLOCK TickCount()

#define SCREEN_WIDTH (qd.screenBits.bounds.right - qd.screenBits.bounds.left)
#define SCREEN_HEIGHT (qd.screenBits.bounds.bottom - qd.screenBits.bounds.top)

#define IDLE_ACTION SpinCursor(16)

Ptr
NewVoidPtr (int t)
{	
	int i;
	char* p = (char*) NewPtr (t);
if (MemError()) Debugger();
	for (i = 0; i <t ; i++)
		p[i] =0;
	return (Ptr) p;
}
#define ALLOC(TYPE) (TYPE*) NewPtr (sizeof(TYPE))
#define ALLOC_RAZ(TYPE)	(TYPE*)NewVoidPtr(sizeof(TYPE))	// allocation et mise  zro
#define FREE(obj) DisposPtr ((Ptr) obj)

#endif MAC

/*----------------------------------------------------------------------------
					FONCTIONS D'ALLOCATIONS ET D'INITIALISATIONS
			Utilises pour construire ou charger une grammaire de geste
----------------------------------------------------------------------------*/

// Allocation et initialisation d'une grammaire :

 void
 DtgInitGrammar (DtgGrammar* gram)
{
	int i=SCREEN_WIDTH;
	int j=SCREEN_HEIGHT;
#ifdef MAC
	CursHandle cursor;
#endif
	gram->x_size =  120.0;
	gram->x_resolution =  i/gram->x_size;
	gram->y_size = 88.0;
	gram->y_resolution =  j/gram->y_size;
	gram->x_offset =0.0;
	gram->y_offset=0.0;
	for (i = 0; i<NWRIST; i++)
		gram->start_confs[i]=NULL;
	gram->is_running=false;
	for (i=0; i<10; i++)
		gram->mid_fingers[i]=45;
	gram->mid_fingers[1] = 22;
	gram->current_fv = FvAlloc();
	gram->last_gesture=0;
	gram->cur_cursor = 0;
#ifdef MAC
	cursor = GetCursor (140);
	if (cursor)  gram->idlecur = **cursor;
	else gram->idlecur = qd.arrow;
	cursor = GetCursor (141);
	if (cursor)  gram->activecur = **cursor;
	else gram->activecur = qd.arrow;
#endif
}

/*----------------------------------------------------------------------------
					FONCTIONS DE CONSTRUCTION DE LA GRAMMAIRE
----------------------------------------------------------------------------*/

// Construction, si besoin, une suite de tableaux reprsentant  une config. de main :

DtgConfigPoint* 
DtgStartFingers (DtgConfigWrist * wrist, DtgStartConfig * config)
{
	DtgConfigThumb* thumb;
	DtgConfigIndex* index;
	DtgConfigMajor* major;
	DtgConfigAnnular* annular;
	DtgConfigAuricular* auricular;
	DtgConfigPoint* point=NULL;
	
	if (wrist->array[config->fingers[0]]==NULL)
		wrist->array[config->fingers[0]]=ALLOC_RAZ(DtgConfigThumb);
	thumb=wrist->array[config->fingers[0]];
	
	if (thumb->array[config->fingers[1]]==NULL)
		thumb->array[config->fingers[1]]=ALLOC_RAZ(DtgConfigIndex);
	index=thumb->array[config->fingers[1]];
	
	if (index->array[config->fingers[2]]==NULL)
		index->array[config->fingers[2]]=ALLOC_RAZ(DtgConfigMajor);
	major=index->array[config->fingers[2]];
	
	if (major->array[config->fingers[3]]==NULL)
		major->array[config->fingers[3]]=ALLOC_RAZ(DtgConfigAnnular);
	annular=major->array[config->fingers[3]];

	if (annular->array[config->fingers[4]]==NULL)
		annular->array[config->fingers[4]]=ALLOC_RAZ(DtgConfigAuricular);
	auricular=annular->array[config->fingers[4]];

	if (config->use_position) {
		for (point = auricular->gestures;  point; point = point->suivant)
			if (point->position == config->position) break;
		if (! point) {
			point =  ALLOC_RAZ (DtgConfigPoint);
			auricular->ngestures++;
			point->position = config->position;
			point->suivant =auricular->gestures;
			auricular->gestures = point;
		}
	}else {
		if (auricular->nopos_gestures==0) {
			auricular->nopos_gestures = ALLOC_RAZ (DtgConfigPoint);
			point = auricular->nopos_gestures;
		} else point = auricular->nopos_gestures;
	}
	return point;
}

void
DtgEndFingers (DtgConfigWrist * wrist, DtgEndConfig * config)
{
	DtgConfigThumb* thumb;
	DtgConfigIndex* index;
	DtgConfigMajor* major;
	DtgConfigAnnular* annular;
	DtgConfigAuricular* auricular;
	
	if (wrist->array[config->fingers[0]]==NULL)
		wrist->array[config->fingers[0]]=ALLOC_RAZ(DtgConfigThumb);
	thumb=wrist->array[config->fingers[0]];
	
	if (thumb->array[config->fingers[1]]==NULL)
		thumb->array[config->fingers[1]]=ALLOC_RAZ(DtgConfigIndex);
	index=thumb->array[config->fingers[1]];
	
	if (index->array[config->fingers[2]]==NULL)
		index->array[config->fingers[2]]=ALLOC_RAZ(DtgConfigMajor);
	major=index->array[config->fingers[2]];
	
	if (major->array[config->fingers[3]]==NULL)
		major->array[config->fingers[3]]=ALLOC_RAZ(DtgConfigAnnular);
	annular=major->array[config->fingers[3]];

	if (annular->array[config->fingers[4]]==NULL)
		annular->array[config->fingers[4]]=ALLOC_RAZ(DtgConfigAuricular);
	auricular=annular->array[config->fingers[4]];
	auricular->ngestures++;
	// *** for the moment, all end configs for a given start config are mixed
}

// Fonction principale qui ajoute un geste  la grammaire :

void 
DtgAddConfig (DtgGrammar* gram, DtgConfig* config)
{
	DtgConfigPoint* point;
	FVList * vectors;
	
	if (gram->start_confs[config->start.wrist]==NULL)
		gram->start_confs[config->start.wrist]=ALLOC_RAZ(DtgConfigWrist);
	point = DtgStartFingers (gram->start_confs[config->start.wrist], &(config->start));
	
	if ((point->gestures == 0) && (config->vectors != 0)) 
		point->gestures = sNewClassifier();
	if (point->gestures) {
		for (vectors = config->vectors;  vectors; vectors = vectors->suivant)
			sAddExample (point->gestures, config->nom, vectors->vector);
	}
	// *** ? ajouter les noms des gestes dans une liste pour le cas ou on n'utilise pas les classifiers ?
	// ajout de la config. de fin :
	if (point->end_confs[config->end.wrist]==NULL)
			point->end_confs[config->end.wrist]=ALLOC_RAZ(DtgConfigWrist);
	DtgEndFingers(point->end_confs[config->end.wrist], &config->end);
}

void
DtgCompile (DtgGrammar* gram)
{
	int i, j, k, l, m, n;
	DtgConfigThumb* t;
	DtgConfigIndex * in;
	DtgConfigMajor * ma;
	DtgConfigAnnular * an;
	DtgConfigAuricular *au;
	DtgConfigPoint * po;
	
	for (i =0 ; i< NWRIST; i++) 
		if (gram->start_confs[i]) {
			for (j=0; j < NFINGER; j++)
				if (t = gram->start_confs[i]->array[j]) {
					for (k = 0; k < NFINGER; k++)
						if (in = t->array[k]) {
							for (l = 0; l < NFINGER; l++) 
								if (ma = in->array[l]) {
									for (m =0 ; m<NFINGER; m++) 
										if (an = ma->array[m]) {
											for (n = 0; n<NFINGER; n++)
												if (au = an->array[n]) {
													if (po = au->nopos_gestures)
														if (po->gestures) {
															sDoneAdding (po->gestures);
															IDLE_ACTION;
														}
													for (po = au->gestures; po ; po = po->suivant)
														if (po->gestures) {
															sDoneAdding (po->gestures);
															IDLE_ACTION;
														}
												}
										}
								}
						}
				}
		}
}

/*----------------------------------------------------------------------------
					Enregistrement DE LA GRAMMAIRE SUR DISQUE
La fonction DtgSaveGrammar est la principale
----------------------------------------------------------------------------*/


void DtgSaveWrist (DtgConfigWrist *, short, Boolean);

void 
DtgSavePoint (DtgConfigPoint* th, short fp)
{
	IOVARS;
	int i;
	WRITE (fp, sizeof(DtgConfigPoint), th);
	if (th->gestures !=0)
		sWrite (th->gestures, fp);
	for (i=0; i<NWRIST; i++) 
		DtgSaveWrist (th->end_confs[i], fp, false);
}

void DtgSaveAuricular (DtgConfigAuricular* au, short fp, Boolean start)
{
	IOVARS;
	DtgConfigPoint * po;
	if (au) {
		WRITE (fp, sizeof(DtgConfigAuricular), au);
		if (start) {
			if (au->nopos_gestures)
				DtgSavePoint (au->nopos_gestures, fp);
			for (po=au->gestures; po; po=po->suivant)
				DtgSavePoint (po, fp);
		}
	}
}

void DtgSaveAnnular (DtgConfigAnnular* th, short fp, Boolean start)
{
	IOVARS;
	int i;
	if (th) {
		WRITE (fp, sizeof(DtgConfigAnnular), th);
		for (i=0; i < NFINGER; i++) 
			DtgSaveAuricular(th->array[i], fp, start);
	}
}

void DtgSaveMajor (DtgConfigMajor* th, short fp, Boolean start)
{
	IOVARS;
	int i;
	if (th) {
		WRITE (fp, sizeof(DtgConfigMajor), th);
		for (i=0; i < NFINGER; i++) 
			DtgSaveAnnular(th->array[i], fp, start);
	}
}

void DtgSaveIndex(DtgConfigIndex * th, short fp, Boolean start) 
{
	IOVARS;
	int i;
	if (th) {
		WRITE (fp, sizeof(DtgConfigIndex), th);
		for (i=0; i < NFINGER; i++) 
			DtgSaveMajor(th->array[i], fp, start);
	}
}

void 
DtgSaveThumb (DtgConfigThumb * th, short fp, Boolean start) 
{
	IOVARS;
	int i;
	if (th) {
		WRITE (fp, sizeof(DtgConfigThumb), th);
		for (i=0; i < NFINGER; i++) 
			DtgSaveIndex(th->array[i], fp, start);
	}
}

void 
DtgSaveWrist (DtgConfigWrist * wrist, short fp, Boolean start)
{
	IOVARS;
	int i;
	if (wrist) {
		WRITE (fp, sizeof(DtgConfigWrist), wrist);
		for (i=0; i < NFINGER; i++) 
			DtgSaveThumb (wrist->array[i], fp, start);
	}
}

void DtgSaveGrammar (DtgGrammar* gram, short fp)
{
	IOVARS;
	int i;
	WRITE (fp, sizeof (DtgGrammar), gram);
	for (i = 0; i < NWRIST; i++)
		DtgSaveWrist (gram->start_confs[i], fp, true);
}

/*----------------------------------------------------------------------------
				CHARGEMENT D'UNE GRAMMAIRE STOCKEE SUR DISQUE
----------------------------------------------------------------------------*/

DtgConfigWrist * DtgLoadWrist (short, Boolean);

DtgConfigPoint * 
DtgLoadPoint (short fp)
{
	IOVARS;
	int i;
	DtgConfigPoint* a =ALLOC_RAZ (DtgConfigPoint);
	READ (fp, sizeof(DtgConfigPoint), a);
	if (a->gestures) {
		a->gestures = sRead (fp);
	}
	for (i = 0; i <NWRIST; i++)
		if (a->end_confs[i])
			a->end_confs[i]=DtgLoadWrist (fp, false);
	return a;
}

DtgConfigAuricular* 
DtgLoadAuricular (short fp, Boolean start)
{
	IOVARS;
	DtgConfigAuricular* a = ALLOC_RAZ(DtgConfigAuricular);
	DtgConfigPoint* tamp;
	int i;
	READ (fp, sizeof(DtgConfigAuricular), a);
	if (start) {
		if (a->nopos_gestures)
			a->nopos_gestures = DtgLoadPoint (fp);
		for (i=0; i < a->ngestures; i++) {
			tamp = DtgLoadPoint (fp);
			tamp->suivant= a->gestures;
			a->gestures = tamp;
		}
	}
	return a;
}

DtgConfigAnnular * 
DtgLoadAnnular (short fp, Boolean start)
{
	IOVARS;
	DtgConfigAnnular * res = ALLOC_RAZ (DtgConfigAnnular);
	int i;
	READ (fp, sizeof(DtgConfigMajor), res);
	for (i=0; i < NFINGER; i++)
		if (res->array[i])
			res->array[i] = DtgLoadAuricular (fp, start);
	return res;
}

DtgConfigMajor * 
DtgLoadMajor (short fp, Boolean start)
{
	IOVARS;
	DtgConfigMajor * res = ALLOC_RAZ (DtgConfigMajor);
	int i;
	READ (fp, sizeof(DtgConfigMajor), res);
	for (i=0; i < NFINGER; i++)
		if (res->array[i])
			res->array[i] = DtgLoadAnnular (fp, start);
	return res;
}

DtgConfigIndex * 
DtgLoadIndex (short fp, Boolean start)
{
	IOVARS;
	DtgConfigIndex * res = ALLOC_RAZ (DtgConfigIndex);
	int i;
	READ (fp, sizeof(DtgConfigIndex), res);
	for (i=0; i < NFINGER; i++)
		if (res->array[i])
			res->array[i] = DtgLoadMajor (fp, start);
	return res;
}

DtgConfigThumb * 
DtgLoadThumb (short fp, Boolean start)
{
	IOVARS;
	DtgConfigThumb * res = ALLOC_RAZ (DtgConfigThumb);
	int i;
	READ (fp, sizeof(DtgConfigThumb), res);
	for (i=0; i < NFINGER; i++)
		if (res->array[i])
			res->array[i] = DtgLoadIndex (fp, start);
	return res;
}

DtgConfigWrist *
DtgLoadWrist (short fp, Boolean start)
{
	IOVARS;
	DtgConfigWrist * res = ALLOC_RAZ (DtgConfigWrist);
	int i;
	READ (fp, sizeof(DtgConfigWrist), res);
	for (i=0; i < NFINGER; i++)
		if (res->array[i])
			res->array[i] = DtgLoadThumb (fp, start);
	return res;
}

Boolean
DtgLoadGrammar (DtgGrammar* gram, short fp)
{
	IOVARS;
	int i;
	READ (fp, sizeof (DtgGrammar), gram);
	gram->is_running=false;
	gram->current_fv = FvAlloc();
	gram->last_gesture=0;
	for (i =0; i < NWRIST; i++) 
		if (gram->start_confs[i])
			gram->start_confs[i] = DtgLoadWrist (fp, true);
	return test == 0;
}

/*----------------------------------------------------------------------------
					FONCTIONS LIEES A LA RECONNAISSANCE D'UN GESTE
----------------------------------------------------------------------------*/

DtgConfigPoint* 
DtgTestConfig (DtgConfigWrist* wrist, DtgHand* hand, Boolean start)
{
	DtgConfigThumb* thumb;
	DtgConfigIndex* index;
	DtgConfigMajor* major;
	DtgConfigAnnular* annular;
	DtgConfigAuricular* auricular;
	DtgConfigPoint* position;
	
	if (! wrist) return NULL;
	thumb = wrist->array[hand->fingers[0]];
	if (!thumb) return NULL;
	index = thumb->array[hand->fingers[1]];
	if (!index) return NULL;
	major = index->array[hand->fingers[2]];
	if (!major) return NULL;
	annular = major->array[hand->fingers[3]];
	if (!annular) return NULL;
	auricular = annular->array[hand->fingers[4]];
	if (!auricular) return NULL;
	
	if (start) {
		for (position = auricular->gestures;  position; position = position->suivant)
			if (position->position == hand->point) break;
		if (! position)
			position = auricular->nopos_gestures;
	} else position = (DtgConfigPoint*) -1;
	return position;
}

FingerBend 
FingerVal (DtgGrammar *gram, int i, int inner, int outer)
{
		if (inner < gram->mid_fingers[i*2]) {
			if (outer < gram->mid_fingers[i*2+1])
				return isBent;
			else return is10;
		} else { 
			if (outer < gram->mid_fingers[i*2+1]) 
				return is01;
			else return isStraight;
		}
}

FingerBend
ThumbVal (DtgGrammar *gram, int inner, int outer)
{
	if (inner < gram->mid_fingers[0] || outer < gram->mid_fingers[1] )
		return isBent;
	else return isStraight;
}

#define MY_PI 3.141592653589
#define MY_ANG  MY_PI / 8.0

WristOrientation 
WristVal (extended w)
{
	if (w < - MY_ANG ) {
		if (w < - MY_ANG * 5.0 ) {
			if (w < - MY_ANG * 7.0) return isEast;
			else return isNEast;
		} else {
			if (w < - MY_ANG * 3.0) return isNorth;
			else return isNWest;
		}
	} else {
		if (w < MY_ANG * 5.0) {
			if (w < MY_ANG * 2.0) return isWest;
			else return isSouth;
		} else {
			if (w < MY_ANG * 7.0) return isSEast;
			else return isEast;
		}
	}
}

// Calcul le point projet, teste s'il est sur l'cran :

Boolean  
DtgProject (DtgGrammar* g, DtgRecord* rec, DtgHand* hand)
{
	FLOAT lacet = - rec->orientation[0];
	FLOAT tangage = - rec->orientation[1];
	FLOAT coslacet = cos (lacet);
	FLOAT costangage = cos (tangage);
	
	hand->point.v = hand->point.h = -1;
	
	if (coslacet != 0 && costangage!=0) {
		FLOAT xpos = rec->position[1] + rec->position[0] * tan (lacet);
		FLOAT ypos = rec->position[2] - rec->position[0] * tan (tangage) / coslacet;
		// *** : here , put a filter in xpos and y pos to accomodate minimal resolution:
		// use a window of about 4 previous hands and make the average
		hand->x = (short) (xpos * g->x_resolution);
		hand->y = (short) (ypos * g->y_resolution);
		hand->z = (short) (((FLOAT) rec->position[0]) / (coslacet * costangage));
		hand->wrist =  WristVal (rec->orientation[2]); 
		hand->time = CLOCK;
		hand->fingers[0]=ThumbVal (g, rec->flex[0], rec->flex[1]);
		hand->fingers[1]=FingerVal (g, 1, rec->flex[2], rec->flex[3]);
		hand->fingers[2]=FingerVal (g, 2, rec->flex[4], rec->flex[5]);
		hand->fingers[3]=FingerVal (g, 3, rec->flex[6], rec->flex[7]);
		hand->fingers[4]=FingerVal (g, 4, rec->flex[8], rec->flex[9]);
		if (xpos >= 0.0 && ypos >= 0.0 && xpos < g->x_size && ypos < g->y_size) {
			hand->point.v = (short) (hand->y / 100); // *** pour l'instant, les points sont 
			hand->point.h = (short) (hand->x / 100); // sur un damier de taille 100 (pixels)	
			return true; 
		}
	}
	return false;
}

// Fonction principale appele  chaque fois que l'on lit sur le port srie :

void DtgClassify (DtgGrammar* gram, DtgResult* res)
{
	Vector v;
	sClassDope result;
	
	gram->is_running=false;
	gram->last_gesture = gram->curhand.time + 60; 
	// no gesture be recognized within 1 second; this value should be settable
	v = FvCalc (gram->current_fv);
	if (gram->cur_gest->gestures) {
		result = sClassify(gram->cur_gest->gestures, v);
		res->name=result->name;
		res->id = result->number;
	}else {
		res->name = "\pUnknown";
		res->id = 0;
	}
	res->start.h=gram->current_fv->startx;
	res->start.v=gram->current_fv->starty;
	res->end.h=gram->current_fv->endx;
	res->end.v=gram->current_fv->endy;
	res->Extent.top=gram->current_fv->miny;
	res->Extent.bottom=gram->current_fv->maxy;
	res->Extent.left=gram->current_fv->minx;
	res->Extent.right=gram->current_fv->maxy;
}

Boolean 
DtgParseGesture (DtgGrammar* gram, DtgRecord* rec, DtgResult* res)
{
	if (DtgProject (gram, rec, &(gram->curhand)))	{ // proj sur l'cran
		if (gram->is_running) { // geste en cours d'acquisition
			if (DtgTestConfig (gram->cur_gest->end_confs[gram->curhand.wrist], 
								&(gram->curhand), false)) { // config de fin de gestes reconnue
				DtgClassify (gram, res);
				DtgEcho (gram, &(gram->curhand));
				return true;
				} 
			FvAddPoint(gram->current_fv, gram->curhand.x, gram->curhand.y, 
								gram->curhand.z,  gram->curhand.fingers, gram->curhand.time);
		} else  {
			if (gram->last_gesture < gram->curhand.time) { // do not start recognizing a new gesture too early
			if (gram->cur_gest = DtgTestConfig (gram->start_confs[ gram->curhand.wrist], 
														&(gram->curhand), true)) { // config dbut de geste
				gram->is_running=true;
				FvInit (gram->current_fv);
				FvAddPoint(gram->current_fv, gram->curhand.x, gram->curhand.y, gram->curhand.z, gram->curhand.fingers, gram->curhand.time);
			}
			}
		}
		DtgEcho (gram, &(gram->curhand));
	} else
		if (gram->is_running) {
			DtgClassify (gram, res);
			DtgEcho (gram, &(gram->curhand));
			return true;
		}
	return false;
}

void DtgFreeWrist (DtgConfigWrist * w)
{
	int j, k, l, m, n ;
	DtgConfigThumb* t;
	DtgConfigIndex * in;
	DtgConfigMajor * ma;
	DtgConfigAnnular * an;
	DtgConfigAuricular *au;
	
	for (j=0; j < NFINGER; j++)
		if (t = w->array[j]) {
			for (k = 0; k < NFINGER; k++)
				if (in = t->array[k]) {
					for (l = 0; l < NFINGER; l++) 
						if (ma = in->array[l]) {
							for (m =0 ; m<NFINGER; m++) 
								if (an = ma->array[m]) {
									for (n = 0; n<NFINGER; n++)
										if (au = an->array[n]) {
											FREE (au);
										}
										FREE (an);
								}
								FREE (ma);
						}
						FREE (in);
				}
				FREE (t);
		}
}

void DtgFreeGrammar (DtgGrammar* gram)
{
	int i, j, k, l, m, n, o;
	DtgConfigThumb* t;
	DtgConfigIndex * in;
	DtgConfigMajor * ma;
	DtgConfigAnnular * an;
	DtgConfigAuricular *au;
	DtgConfigPoint * po;
	
	for (i =0 ; i< NWRIST; i++) 
		if (gram->start_confs[i]) {
			for (j=0; j < NFINGER; j++)
				if (t = gram->start_confs[i]->array[j]) {
					for (k = 0; k < NFINGER; k++)
						if (in = t->array[k]) {
							for (l = 0; l < NFINGER; l++) 
								if (ma = in->array[l]) {
									for (m =0 ; m<NFINGER; m++) 
										if (an = ma->array[m]) {
											for (n = 0; n<NFINGER; n++)
												if (au = an->array[n]) {
													if (po = au->nopos_gestures) {
														if (po->gestures) 
															sFreeClassifier (po->gestures);
														for (o=0; o < NWRIST; o++)
															if (po->end_confs[o])
																DtgFreeWrist (po->end_confs[o]);
														FREE (po);
													}
													while (au->gestures) {
														po = au->gestures;
														if (po->gestures)
															sFreeClassifier (po->gestures);
														for (o=0; o < NWRIST; o++)
															if (po->end_confs[o]) {
																DtgFreeWrist (po->end_confs[o]);
																FREE (po->end_confs[o]);
															}
														au->gestures = po->suivant;
														FREE (po);
													}
													FREE (au);
												}
												FREE (an);
										}
										FREE (ma);
								}
								FREE (in);
						}
						FREE (t);
				}
				FREE (gram->start_confs[i]);
				gram->start_confs[i] = NULL;
		}
		if (gram->current_fv) FvFree (gram->current_fv);
		gram->current_fv=NULL;
}

void 
DtgEcho (DtgGrammar* gram, DtgHand* hand)
{
	if (gram->is_running && gram->cur_cursor != 1) {
		gram->cur_cursor = 1;
#ifdef MAC
		SetCursor (&(gram->activecur));
#endif
	} else if (!gram->is_running && gram->cur_cursor == 1) {
		gram->cur_cursor = 0;
#ifdef MAC
		SetCursor (&(gram->idlecur));
#endif
	}
	if (hand->point.v != -1)
		PutMouse (hand->x, hand->y);
	// else cacher le curseur ? *** 
}